' Summary: rangetool.bas
' Contains a set of wrappers for returning ranges of connector and engine values
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "mos/drivercom.bi"
#include "mos/gfx.bi"


' Function: EngineReturnSimpleRange
' Creates and sends a single sized range reply
'
' in:
'     Source  - message address of the requesting application
'     Index   - Engine index
'     Prop    - The property requested
'     First   - The lower bound (inclusive) of valid values
'     Last    - The upper bound (inclusive) of valid values
'     Modulus - The difference between consecutive values
'
' out:
'     none
'
Sub EngineReturnSimpleRange CDecl Alias "EngineReturnSimpleRange" (ByVal Source As Integer, ByVal Index As Integer, ByVal Prop as Integer, ByVal First as Integer, ByVal Last as Integer, ByVal Modulus As Integer)
    Dim msg(0 to 7) As Integer

    msg(0) = GFXCOMMAND_RANGEENGINE
    msg(1) = 1 ' not using a reply id
    msg(2) = Index
    msg(3) = Prop
    msg(4) = First
    msg(5) = Last
    msg(6) = Modulus
    drv_sendmessage(Source, 28, CPtr(Byte Ptr, @(msg(0))))
End Sub



' Function: ConnectorReturnSimpleRange
' Creates and sends a single sized range reply
'
' in:
'     Source  - message address of the requesting application
'     Index   - Engine index
'     Prop    - The property requested
'     First   - The lower bound (inclusive) of valid values
'     Last    - The upper bound (inclusive) of valid values
'     Modulus - The difference between consecutive values
'
' out:
'     none
'
Sub ConnectorReturnSimpleRange CDecl Alias "ConnectorReturnSimpleRange" (ByVal Source As Integer, ByVal Index As Integer, ByVal Prop as Integer, ByVal First as Integer, ByVal Last as Integer, ByVal Modulus As Integer)
    Dim msg(0 to 7) As Integer

    msg(0) = GFXCOMMAND_RANGECONNECTOR
    msg(1) = 0
    msg(2) = Index
    msg(3) = Prop
    msg(4) = First
    msg(5) = Last
    msg(6) = Modulus
    drv_sendmessage(Source, 28, CPtr(Byte Ptr, @(msg(0))))
End Sub



' Function: EngineReturnConstantRange
' Creates and sends a range reply which specifies only a single valid value (i.e. the property is a constant)
'
' in:
'     Source - message address of the requesting application
'     Index  - Engine index
'     Prop   - The property requested
'     Value  - The hardwired value
'
' out:
'     none
'
Sub EngineReturnConstantRange CDecl Alias "EngineReturnConstantRange" (ByVal Source As Integer, ByVal Index As Integer, ByVal Prop as Integer, ByVal Value As Integer)
    Dim msg(0 to 7) As Integer

    msg(0) = GFXCOMMAND_RANGEENGINE
    msg(1) = 1
    msg(2) = Index
    msg(3) = Prop
    msg(4) = Value
    msg(5) = Value
    msg(6) = 1
    drv_sendmessage(Source, 28, CPtr(Byte Ptr, @(msg(0))))
End Sub



' Function: ConnectorReturnConstantRange
' Creates and sends a range reply which specifies only a single valid value (i.e. the property is a constant)
'
' in:
'     Source - message address of the requesting application
'     Index  - Engine index
'     Prop   - The property requested
'     Value  - The hardwired value
'
' out:
'     none
'
Sub ConnectorReturnConstantRange CDecl Alias "ConnectorReturnConstantRange" (ByVal Source As Integer, ByVal Index As Integer, ByVal Prop as Integer, ByVal Value As Integer)
    Dim msg(0 to 7) As Integer

    msg(0) = GFXCOMMAND_RANGECONNECTOR
    msg(1) = 0
    msg(2) = Index
    msg(3) = Prop
    msg(4) = Value
    msg(5) = Value
    msg(6) = 1
    drv_sendmessage(Source, 28, CPtr(Byte Ptr, @(msg(0))))
End Sub



' Function: EngineReturnBooleanRange
' Creates and sends a range reply deescribing a property having exactly two values
'
' in:
'     Source - message address of the requesting application
'     Index  - Engine index
'     Prop   - The property requested
'     Value1 - The first value possible
'     Value2 - The second value possible
'
' out:
'     none
'
Sub EngineReturnBooleanRange CDecl Alias "EngineReturnBooleanRange" (ByVal Source As Integer, ByVal Index As Integer, ByVal Prop as Integer, ByVal Value1 As Integer, ByVal Value2 As Integer)
    Dim msg(0 to 10) As Integer
    msg(0) = GFXCOMMAND_RANGEENGINE
    msg(1) = 1
    msg(2) = Index
    msg(3) = Prop
    msg(4) = Value1
    msg(5) = Value1
    msg(6) = 1
    msg(7) = Value2
    msg(8) = Value2
    msg(9) = 1
    drv_sendmessage(Source, 40, CPtr(Byte Ptr, @(msg(0))))
End Sub



' Function: ConnectorReturnBooleanRange
' Creates and sends a range reply deescribing a property having exactly two values
'
' in:
'     Source - message address of the requesting application
'     Index  - Engine index
'     Prop   - The property requested
'     Value1 - The first value possible
'     Value2 - The second value possible
'
' out:
'     none
'
Sub ConnectorReturnBooleanRange CDecl Alias "ConnectorReturnBooleanRange" (ByVal Source As Integer, ByVal Index As Integer, ByVal Prop as Integer, ByVal Value1 As Integer, ByVal Value2 As Integer)
    Dim msg(0 to 10) As Integer
    msg(0) = GFXCOMMAND_RANGECONNECTOR
    msg(1) = 0
    msg(2) = Index
    msg(3) = Prop
    msg(4) = Value1
    msg(5) = Value1
    msg(6) = 1
    msg(7) = Value2
    msg(8) = Value2
    msg(9) = 1
    drv_sendmessage(Source, 40, CPtr(Byte Ptr, @(msg(0))))
End Sub
