' Summary: rawvgatk.bas
' Implementation of a bunch of VGA-specific widgets toolkit
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

Common Shared cram As Byte Ptr

' Function: PrintString
' Prints a string to video memory
'
' s - the string to be printed
' vram - pointer to video memory to print to
Sub PrintString (ByRef s As String, ByVal offset as long = 0, ByVal colour as byte = &H17)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        cram[lp * 2 - 2 + offset] = ch
        cram[lp * 2 - 1 + offset] = colour
    Next lp
End Sub

Sub ClearScreen()
    Dim lp As Long
    For lp = 0 to 160 * 25 - 1 Step 2
        cram[lp] = 32
        cram[lp+1] = &H07
    Next lp
End Sub

Sub DrawWindow(ByVal sx as integer, ByVal sy as integer, ByVal w as integer, ByVal h as integer, ByVal colour As Byte)
    Dim lpx as long
    Dim lpy as long

    for lpy = sy - 1 to sy + h
    for lpx = sx - 1 to sx + w
        cram[2*lpx + 160*lpy] = 0
        cram[2*lpx + 160*lpy + 1] = colour
    next lpx
    next lpy

    for lpx = sx to sx + w
        cram[2*lpx + 160 * (sy - 1)] = CByte(&HCD)
        cram[2*lpx + 160 * (sy+h)] = CByte(&HCD)
    next lpx
    for lpy = sy to sy + h
        cram[2*sx-2   + 160 * lpy] = CByte(&HBA)
        cram[2*sx+2*w + 160 * lpy] = CByte(&HBA)
    next lpy

    cram[2 * sx + 160 * sy - 162] = CByte(&HC9)
    cram[2 * (sx+w) + 160 * sy - 160] = CByte(&HBB)
    cram[2 * sx + 160 * (sy+h) - 2] = CByte(&HC8)
    cram[2 * (sx+w) + 160 * (sy+h)] = CByte(&HBC)

End Sub