' Summary: trio64_blit.bas
' Hardware accelerated blitting for the Trio64
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "trio64_drv.bi"
#include "x86.bi"

Sub Trio64_BlitFill(x As Integer, y As Integer, w As Integer, h As Integer, colour As Integer)

    Trio64_WaitFifobits(7)

    ' background mix
    outportw(&HBAE8, &H27) ' SRC = foreground; MIX = SRC

    ' push parameters
    outportw(&H82E8, y)
    outportw(&H86E8, x)
    outportw(&H96E8, w-1)
    outportw(&HBEE8, h-1)
    outportd(&HA6E8, colour)

    ' send command
    outportw(&H9AE8, &H40B1)

End Sub

Sub Trio64_BlitFillSpecial(x As Integer, y As Integer, w As Integer, h As Integer, colour As Integer, op As Integer)

    Trio64_WaitFifobits(7)

    ' background mix
    outportw(&HBAE8, &H20 + op) ' SRC = foreground; MIX = op

    ' push parameters
    outportw(&H82E8, y)
    outportw(&H86E8, x)
    outportw(&H96E8, w-1)
    outportw(&HBEE8, h-1)
    outportd(&HA6E8, colour)

    ' send command
    outportw(&H9AE8, &H40B1)

End Sub

Sub Trio64_Blit(srcx As Integer, srcy As Integer, dstx As Integer, dsty As Integer, w As Integer, h As Integer)

    Trio64_WaitFifobits(3)

    ' Select source bmp
    outportw(&H82E8, srcy)
    outportw(&H86E8, srcx)

    ' background mix
    outportw(&HBAE8, &H67) ' SRC = video memory; MIX = src


    Trio64_WaitFifobits(5)

    ' push parameters
    outportw(&H8AE8, dsty)
    outportw(&H8EE8, dstx)
    outportw(&H96E8, w-1)
    outportw(&HBEE8, h-1)

    ' send command
    outportw(&H9AE8, &HC0B1) ' Send command - BitBlit, X incrementing, Y incrementing, Write enable, Access enable

End Sub

Sub Trio64_BlitKeyed(srcx As Integer, srcy As Integer, dstx As Integer, dsty As Integer, w As Integer, h As Integer, colour As Integer)

    Trio64_WaitFifobits(5)

    ' Set colorkey
    outportw(&HBEE8, &HE100) ' enable keyed blit
    outportd(&HB2E8, colour)

    ' Select source bmp
    outportw(&H82E8, srcy)
    outportw(&H86E8, srcx)

    ' background mix
    outportw(&HBAE8, &H67) ' SRC = video memory; MIX = src

    Trio64_WaitFifobits(6)

    ' Select dest bitmap
    outportw(&H8AE8, dsty)
    outportw(&H8EE8, dstx)

    ' Select bitmap size
    outportw(&H96E8, w-1)
    outportw(&HBEE8, h-1)

    ' send command
    outportw(&H9AE8, &HC0B1) ' Send command - BitBlit, X incrementing, Y incrementing, Write enable, Access enable
    outportw(&HBEE8, &HE000) ' disable keyed blit

End Sub