' Summary: trio64_core.bas
' Core functionality for the Trio64 class of graphics adapters
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "mos/gfx.bi"
#include "mos/bga_regs.bi"
#include "mos/drivercom.bi"
#include "mos/driver.bi"
#include "mos/pci.bi"
#include "mos.bi"
#include "x86.bi"

#include "GL/mgl.bi"
#include "GL/gl.bi"

#include "trio64_drv.bi"
#include "../vga_io.bi"

Declare Sub _gl_setoutput CDecl Alias "_gl_setoutput"(ByVal buffer As Byte Ptr, ByVal w As Integer, ByVal h As Integer, ByVal pitch As Integer)
Declare Sub _gl_inittextures CDecl Alias "_gl_inittextures" ()

Common Shared Trio64_framebuffer As Byte Ptr

Public Sub PrintString (s As String, vram As Byte Ptr, offset As Integer)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        vram[lp * 2 - 2 + 2 * offset] = ch
        vram[lp * 2 - 1 + 2 * offset] = 7
    Next lp
End Sub

Sub modmain CDecl Alias "main" (argc As Integer, argv As Byte Ptr Ptr)

    'I/O permission bitmap
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    portalloc(&HCF8, 8)
    'VGA RAM
    allocatepagetable(CPtr(Byte Ptr, &H0), CPtr(Byte Ptr, -1))
    blockallocphys(32, CPtr(Byte Ptr, &HA0000), CPtr(Byte Ptr, &HA0000))

    _gl_inittextures

    glMatrixMode GL_PROJECTION
    glLoadIdentity
    glMatrixMode GL_MODELVIEW
    glLoadIdentity
    glColor3f 1, 1, 1

    ' setup code here
    Dim devid As Integer
    devid = DriverInit      ' initialize driver, get device ID

    ' Get device location
    Dim devloc As String
    Dim devmsg(0 to 1) As Integer
    devmsg(0) = 10
    devmsg(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000, 8, CPtr(Byte Ptr, @(devmsg(0))))

    ' wait for response
    Dim Location As String
    While Location = ""
        While drv_peekmessage() = 0
            Yield
        Wend

        Dim rs As String
        rs = space$(drv_peekmessage())
        Dim rv As Integer
        rv = drv_readmessage(*CPtr(Byte Ptr Ptr, @rs))
        If rv = DRIVER_MGR * &H10000 Then
            location = rs
        End if
    Wend

    ' Todo: replace with a call to pciserv
    Dim bus as integer
    dim dev as integer
    dim dfn as integer
    bus = Valint("&H" & mid$(location,  5, 2))
    dev = Valint("&H" & mid$(location,  8, 2))
    dfn = Valint("&H" & mid$(location, 11, 2))

    Dim ioaddr As Integer
    Dim framebuffer As Byte Ptr
    Dim bar As Integer

    PrintString "PCI: " & hex$(bus) & ":" & hex$(dev) & ":" & hex$(dfn) & " " & hex$(pci_type1_readdword(bus,dev,dfn,0)), CPtr(Byte Ptr, &HB8000), 80
    PrintString location, CPtr(Byte Ptr, &HB8000), 320

    Dim i As Integer
    For i = &H10 to &H1C Step 4
        bar = pci_type1_readdword(bus, dev, dfn, i)
        PrintString "bar @ 0x" & hex$(i) & " = 0x" & hex$(bar), CPtr(Byte Ptr, &HB8000), 400 + 20 * (i - 16)
        If (Bar <> 0) And ((bar and &HFFFF0) = 0) And (framebuffer = CPtr(Byte Ptr, 0)) Then
            framebuffer = CPtr(Byte Ptr, (bar and &HFFFF0000))
        End If
    Next i

    PrintString "fbaddr: " & hex$(framebuffer), CPtr(Byte Ptr, &HB8000), 240

    ' Allocate hardware resources
    ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), framebuffer)
    Trio64_framebuffer = CPtr(Byte Ptr, &H60000000)
    BlockAllocPhysL(1, Trio64_framebuffer, framebuffer)
    
    ' Allocate the sparse IO map. This system makes the Trio64 a *really* nasty device for resource management.
    For i = &H42E8 to &H4AE8 step &H400
        portalloc(i, 4)         ' GPU-1
    Next i
    For i = &H82E8 to &HBEE8 step &H400
        portalloc(i, 4)         ' GPU-2
    Next i
    portalloc(&HE2E8, 4)        ' GPU-3
    portalloc(&H3B0, &H30)      ' The (S)VGA range
    portalloc(&H102, 1)         ' Config-1


    ' register driver in device manager
    drv_setname(0,1)
    dim msg(0 to 1) As integer
    msg(0) = 7
    msg(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )

    _gl_setoutput(Trio64_framebuffer, 640, 480, 640*4)

    ' load VGA register settings
    VGASet640x480x16Mode

    ' LFB aperture
    Write3D4(&H58, Read3D4(&H58) Or &H13) ' Enable aperture, select maximum size

    ' Unlock S3 Extended regs
    Write3C4(&H08, &H06) ' PLL lock
    Write3D4(&H38, &H48) ' CR lock #1
    Write3D4(&H39, &HA5) ' CR lock #2
    Write3D4(&H33, Read3D4(&H33) And &HAD) ' VGA lock

    ' Enhanced mode
    outportb(&H46E8, &H10)
    outportb(&H102, &H1)
    outportb(&H46E8, &H10)

    ' configuration
    outportw(&H4AE8, 1)
    Write3D4(&H31, Read3D4(&H31) Or &H09) ' diable bank mode, enable enhanced memory mapping. Effectively unfolds VGA planes
    Write3D4(&H13, 160)                   ' 640 * 2 / 8
    Write3C4 &H2, &HF                     ' all planes enabled

    Write3D4(&H67, (Read3D4(&H67) And &H0F) Or &H50) ' 16bpp format
    Write3D4(&H3A, &H35) ' Advanced pixel shift mode
    Write3D4(&H43, &H08) ' 64K color mode, single data rate. (double data rate causes the even pixels to be replaced by the odd ones)
    Write3D4(&H50, (Read3D4(&H50) And &HCF) Or &H10)         ' Bit format stuff

    socket.height = 480
    socket.width = 640
    socket.os_l = 8
    socket.os_r = 8
    socket.os_t = 8
    socket.os_b = 8
    socket.blank_l = 8
    socket.blank_r = 8
    socket.blank_t = 8
    socket.blank_b = 8
    socket.input = 3
    socket.enabled = 0

    Dim driver As GFXDRIVER2
    driver.Connectors = 1
    driver.Engines = 6 ' 8bpp, 16bpp, 24bpp, 32bpp, 15bpp, hardware cursor
    driver.setconnectorstate = @Trio64_ConnectorSetState
    driver.getconnectorstate = @Trio64_ConnectorGetState
    driver.getconnectorrange = @Trio64_ConnectorGetRange
    driver.setenginestate = @Trio64_EngineSetState
    driver.getenginestate = @Trio64_EngineGetState
    driver.getenginerange = @Trio64_EngineGetRange
    driver.gldispatch = @Trio64_GLDispatch

    graphicsmain2(driver, CPtr(Byte Ptr, 0))

End Sub

