' Summary: trio64_socket.bas
' The connector controls for the Trio64
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "trio64_drv.bi"
#include "mos/gfx.bi"
#include "../vga_io.bi"
#include "swgl/glbuffer.bi"

Common Shared socket As Trio64_socket

Function Trio64_ConnectorSetState CDecl (info As Byte Ptr, index As Integer, prop As Integer, value As Integer) As Integer
    Function = 0
    if index <> 0 Then exit function
    Select Case prop

        Case GFX_PROP_ENABLE
            If value <> 0 Then

                Dim actualmode As Integer
                actualmode = socket.input ' or the cursor's input
                Dim pb As Integer, bpp As Integer, bytesper As Integer
                Dim extmiscctl As Unsigned Byte, extmode As Unsigned Byte
                Dim extsysctl1 As Unsigned Byte
                Dim bit8reg_a As Unsigned Byte, bit8reg_b As Unsigned Byte

                ' prepare depth-specific settings
                extmiscctl = Read3D4(&H67) And &H0F
                extsysctl1 = Read3D4(&H50) And &HCF
                extmode = Read3D4(&H43) And &HF3 ' mask virtual width bits
                bit8reg_a = Read3C4(&H15) And &HEF
                bit8reg_b = Read3C4(&H18) And &H7F


                Select Case actualmode
                    Case 0
                        pb = 1
                        bpp = 8
                        bytesper = 1
                        'extmode = &H08 'extmode Or &H0
                        extsysctl1 = extsysctl1 Or &H00
                        extmiscctl = extmiscctl Or &H00
                        bit8reg_a = bit8reg_a Or &H10
                        bit8reg_b = bit8reg_b Or &H80
                        '_gl_writebuffer = ?
                        '_gl_fillbuffer = ?

                    Case 1
                        pb = 2
                        bpp = 16
                        bytesper = 2
                        extmode = extmode Or &H08 ' 64K colors
                        extsysctl1 = extsysctl1 Or &H10
                        extmiscctl = extmiscctl Or &H50
                        _gl_backbuffer->writebuffer = @_gl_writebuffer_b5g6r5
                        _gl_backbuffer->fillbuffer = @_gl_fillbuffer_b5g6r5

                    Case 2 'only supported by ViRGE VX
                        pb = 1
                        bpp = 24
                        bytesper = 3
                        'extmode = &H8C
                        extsysctl1 = extsysctl1 Or &H00
                        extmiscctl = extmiscctl Or &HD0
                        _gl_backbuffer->writebuffer = @_gl_writebuffer_b8g8r8
                        _gl_backbuffer->fillbuffer = @_gl_fillbuffer_b8g8r8

                    Case 3 'not supported by ViRGE VX
                        pb = 1
                        bpp = 32
                        bytesper = 4
                        'extmode =
                        extsysctl1 = extsysctl1 Or &H30
                        extmiscctl = extmiscctl Or &HD0
                        _gl_backbuffer->writebuffer = @_gl_writebuffer_b8g8r8x8
                        _gl_backbuffer->fillbuffer = @_gl_fillbuffer_b8g8r8a8

                    Case 4 'not on VirtualPC?
                        pb = 2
                        bpp = 15
                        bytesper = 2
                        extsysctl1 = extsysctl1 Or &H10
                        extmiscctl = extmiscctl Or &H30
                        _gl_backbuffer->writebuffer = @_gl_writebuffer_b5g5r5
                        _gl_backbuffer->fillbuffer = @_gl_fillbuffer_b5g5r5
                End select

                ' CRTC as vga, additional overflow biths in 3D4/5D and 3D4/5E
                Dim hclocks As Integer, htotal As Integer, hdispend As Integer, hblankstart As Integer
                Dim hsyncstart As Integer, hsyncend As Integer, hblankend As Integer
                Dim vtotal As Integer, vdispend As Integer, vblankstart As Integer, vsyncstart As Integer
                Dim vsyncend As Integer, vblankend As Integer
                Dim overflowregister As Unsigned Byte, scanlineregister As Unsigned Byte
                Dim horizontaloverflow As Unsigned Byte, verticaloverflow As Unsigned Byte, virtwidth As Integer

                ' compute parameter values for horizontal timings
                hclocks = pb * (socket.width + socket.os_l + socket.os_r + socket.blank_l + socket.blank_r + socket.h_sync) / 8
                htotal = hclocks - 5
                hdispend = pb * socket.width / 8 - 1
                hblankstart = pb * (socket.width + socket.os_r) / 8 - 1
                hsyncstart = pb * (socket.width + socket.os_r + socket.blank_r) / 8 - 1
                hsyncend = pb * (socket.width + socket.os_r + socket.blank_r + socket.h_sync) / 8 - 1
                hblankend = pb * (socket.width + socket.os_r + socket.blank_r + socket.h_sync + socket.blank_l) / 8 - 1
                virtwidth = socket.width * bytesper \ 8

                ' todo: check where the new bits go
                hsyncend = (hsyncend Mod (hclocks - 1)) And &H1F
                hblankend = (hblankend Mod (hclocks - 1)) And &H3F


                ' compute parameter values for vertical timings
                vtotal = socket.height + socket.os_t + socket.os_b + socket.blank_t + socket.blank_b + socket.v_sync
                vdispend = socket.height - 1
                vblankstart = socket.height + socket.os_b - 1
                vsyncstart = socket.height + socket.os_b + socket.blank_b
                vsyncend = socket.height + socket.os_b + socket.blank_b + socket.v_sync
                vblankend = socket.height + socket.os_b + socket.blank_b + socket.v_sync + socket.blank_t

                ' prepare registers, mangle and pack to VGA register format
                '   hsyncend register: 7 = HBE5 6..5 = reserved 4..0 = hsyncend
                if (hblankend >= &H20) Then hsyncend = hsyncend Or &H80
                '   hblankend register: 7 = reserved(1) 6..5 = skew(0) 4..0 = hblankend
                hblankend = (hblankend And &H1F) Or &H80 ' drop bits, add reserved bit
                '   overflow register: contains bits 8/9 of several other registers
                overflowregister = &H10        ' LC8 is set by default, the rest is set as follows:
                if (vtotal And &H100)      > 0 Then overflowregister = overflowregister + &H01
                if (vdispend And &H100)    > 0 Then overflowregister = overflowregister + &H02
                if (vsyncstart And &H100)  > 0 Then overflowregister = overflowregister + &H04
                if (vblankstart And &H100) > 0 Then overflowregister = overflowregister + &H08
                if (vtotal And &H200)      > 0 Then overflowregister = overflowregister + &H20
                if (vdispend And &H200)    > 0 Then overflowregister = overflowregister + &H40
                if (vsyncstart And &H200)  > 0 Then overflowregister = overflowregister + &H80
                if (virtwidth and &H100)   > 0 Then extmode = extmode + &H04
                '   max scan line register: contains bit 9 of vertical blank start register, and the doublescan bit
                '   as well as the character height
                scanlineregister = &H40
                if (vblankstart And &H200) Then scanlineregister = scanlineregister + &H20

                ' vertical retrace end: contains memory control and crtc protect
                vsyncend = (Read3D4(&H11) And &HF0) Or (vsyncend And &H0F)

                'CRTC registers
                'u = undocumented, 
                'd = register changes with bpp
                's = register changes with resolution
                '
                '     +0   +1   +2   +3   +4   +5   +6   +7
                '00    ds   ds   ds   ds   ds   ds   ds   ds  
                '08   0x00  ds  0x00 0x00 0x00 0x00 0xff 0x00 
                '10    d    ds    s   ds   ds   ds   ds    s  
                '18   u    u    u    u    u    u    u    u    
                '20   u    ud   0x00 ud   ud   ud   ud   ud   
                '28   ud   ud   ud   ud   ud   0x89 0x01 0x04 
                '30   0xe1  d   0x00 0x00 0x10  d   0xd6 0x0f 
                '38   0x4b  d    d    ds   ds  uds  uds  uds  
                '40   0x01 0x08 0x08  d   ud    d    ds  uds  
                '48    d   ud   0xff 0x00  d   ud    d    d   
                '50    d    d   0x80  d    d   0x00 0x00 0x00 
                '58    d   0xf8 u    0x00 0x03 0x00 0x00 0x00 
                '60   0xff 0x9f 0x9f 0x00 0x00 0x04 0x89 0x00 
                '68   0xf3 0xe0 0xc0 0x00 0x03 u    u    u    
                '70   u    u    u    u    u    u    u    u    
                '78   u    u    u    u    u    u    u    u    
                '
                'registers that should be updated:
                '00 01 02 03 04 05 06 07 09 10 11 12 13 14 15
                '16 17 31 35 39 3A 3B 3C 43 45 46 48 4C 4E 4F
                '50 51 53 54 58

                Write3D4(&H0, htotal)
                Write3D4(&H1, hdispend)
                Write3D4(&H2, hblankstart)
                Write3D4(&H3, hblankend)
                Write3D4(&H4, hsyncstart)
                Write3D4(&H5, hsyncend)
                Write3D4(&H6, vtotal)
                Write3D4(&H7, overflowregister)
                Write3D4(&H9, scanlineregister)
                ' Register gap here, in case you wonder.
                Write3D4(&H10, vsyncstart)
                Write3D4(&H11, vsyncend)
                Write3D4(&H12, vdispend)
                Write3D4(&H13, virtwidth)
                Write3D4(&H15, vblankstart)
                Write3D4(&H16, vblankend)

                Write3D4(&H17, Read3D4(&H17) Or &H80)
   	            Write3C4(&H01, Read3C4(&H01) And &HDF) ' screen disable

                '17 31 35


                ' from linux driver (changes vpc behaviour)
                Write3D4(&H54, &H18) ' M parameter
            	Write3D4(&H60, &Hff) ' N parameter
            	Write3D4(&H61, &Hff) ' L parameter
            	Write3D4(&H62, &Hff) ' L parameter
            	Write3D4(&H3A, &H35)

                ' Trio64 registers
                Write3D4(&H3B, (htotal+hsyncstart+1) \ 2)
                Write3D4(&H43, extmode) ' virtual width bit 8
                Write3D4(&H50, extsysctl1)

                Write3C4(&H15, bit8reg_a)
                Write3C4(&H18, bit8reg_b)
                
                'note: register 67 unused on Trio64V2 DX/GX, required for VirtualPC/V+? 
                Write3D4(&H67, extmiscctl)

                _gl_setoutput(Trio64_framebuffer, socket.width, socket.height, socket.width * bytesper)

                socket.enabled = 1
            Else
                '	svga_wseq_mask(0x01, 0x20, 0x20);
	            '    svga_wcrt_mask(0x17, 0x00, 0x80);

   	            Write3C4(&H01, Read3C4(&H01) Or &H20) ' screen disable
	            Write3D4(&H17, Read3D4(&H17) And &H7F)


                socket.enabled = 0
            End If

        Case GFX_PROP_INPUT
            If value < 0 Then Exit Function
            If value > 4 Then Exit Function
            If socket.enabled > 0 Then Exit Function
            socket.input = value

        ' Todo: Check all settings for sanity

        Case GFX_PROP_WIDTH
            If socket.enabled > 0 Then Exit Function
            socket.width = value

        Case GFX_PROP_HEIGHT
            If socket.enabled > 0 Then Exit Function
            socket.height = value

        Case GFX_PROP_VGA_H_FRONT_PORCH
            If socket.enabled > 0 Then Exit Function
            socket.blank_r = value - (value mod 8) - socket.os_r

        Case GFX_PROP_VGA_H_BACK_PORCH
            If socket.enabled > 0 Then Exit Function
            socket.blank_l = value - (value Mod 8) - socket.os_l

        Case GFX_PROP_VGA_H_SYNC
            If socket.enabled > 0 Then Exit Function
            socket.h_sync = value - (value Mod 8)

        Case GFX_PROP_VGA_V_FRONT_PORCH
            If socket.enabled > 0 Then Exit Function
            socket.blank_b = value - socket.os_b

        case GFX_PROP_VGA_V_BACK_PORCH
            If socket.enabled > 0 Then Exit Function
            socket.blank_t = value - socket.os_t

        case GFX_PROP_VGA_V_SYNC
            If socket.enabled > 0 Then Exit Function
            socket.v_sync = value

    End Select
End Function

Function Trio64_ConnectorGetState CDecl (info As Byte Ptr, index As Integer, prop As Integer) As Integer
    Function = 0
    if index <> 0 Then exit function
    Select Case prop
        Case GFX_PROP_ENABLE
            Function = socket.enabled
        Case GFX_PROP_INPUT
            Function = socket.input
        Case GFX_PROP_WIDTH
            Function = socket.width
        Case GFX_PROP_HEIGHT
            Function = socket.height

        Case GFX_PROP_SIGNAL
            Function = GFX_SIGNAL_RGBHV
        Case GFX_PROP_CONNECTOR_TYPE
            Function = GFX_CONNECTOR_VGA
        Case Else
    End Select
End Function

Function Trio64_ConnectorGetRange CDecl (info As Byte Ptr, source As Integer, index As Integer, prop As Integer) As Integer
    if index = 0 Then
        Function = 1
        Select case prop
            Case GFX_PROP_ENABLE
                ConnectorReturnBooleanRange(source, index, prop, 0, 1)
            Case GFX_PROP_INPUT
                ConnectorReturnSimpleRange(source, index, prop, 0, 4, 1)
            Case GFX_PROP_WIDTH
                ConnectorReturnSimpleRange(source, index, prop, 320, 1024, 8)
            Case GFX_PROP_HEIGHT
                ConnectorReturnSimpleRange(source, index, prop, 240, 768, 8)
            Case GFX_PROP_SIGNAL
                ConnectorReturnConstantRange(source, index, prop, GFX_SIGNAL_RGBHV)
            Case GFX_PROP_CONNECTOR_TYPE
                ConnectorReturnConstantRange(source, index, prop, GFX_CONNECTOR_VGA)

            Case Else
                Function = 0
        End select
    Else
        Function = 0
    End If
End Function

