/* Summary: udivga.bas
 * Core functionality for the IBM VGA (udi build)
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Educational Purposes>
 */

#define UDI_VERSION 0x101
#define UDI_GFX_VERSION 0x101

#include <udi.h>
#include <udi_gfx1.h>
#include <mos.h>
#include <x86.h>
#include <stdlib.h>

extern void bochs_puts(const char * s);
extern void bochs_putu(udi_ubit32_t i);

int VGA_ConnectorSetState(void * info, int index, int prop, int value);
int VGA_EngineSetState(void * info, int index, int prop, int value);
int VGA_ConnectorGetState(void * info, int index, int prop);
int VGA_EngineGetState(void * info, int index, int prop);
int VGA_ConnectorGetRange(void * info, int index, int prop, int * startval, int * endval, int * modval);
int VGA_EngineGetRange(void * info, int index, int prop, int * startval, int * endval, int * modval);
void VGA_EngineDefaults(void);
void VGAUnlockCRTC(void);
void VGASetTextMode(void);
void VGAEnableDisplay(void);
int VGA_GLDispatch(void * info, void * data, int length);

// define block meta entry points
udi_channel_event_ind_op_t          vga_channel_event_ind;
udi_gfx_bind_req_op_t               vga_gfx_bind_req;
udi_gfx_unbind_req_op_t             vga_gfx_unbind_req;
udi_gfx_set_connector_req_op_t      vga_gfx_set_connector_req;
udi_gfx_set_engine_req_op_t         vga_gfx_set_engine_req;
udi_gfx_get_connector_req_op_t      vga_gfx_get_connector_req;
udi_gfx_get_engine_req_op_t         vga_gfx_get_engine_req;
udi_gfx_range_connector_req_op_t    vga_gfx_range_connector_req;
udi_gfx_range_engine_req_op_t       vga_gfx_range_engine_req;
udi_gfx_command_req_op_t            vga_gfx_command_req;

void vga_channel_event_ind (udi_channel_event_cb_t *channel_event_cb)
{
    if (channel_event_cb) {} // TODO: implement me
}

void vga_gfx_bind_req (udi_gfx_bind_cb_t *cb)
{
    //allocateiobitmap(0x3B0, 0x30, (int *) -1);
    portalloc(0x3B0, 0x30);
    
    allocatepagetable((void *) 0, (void *) -1);
    blockallocphys(32, (void *)0xA0000, (void *)0xA0000);
    
    // initialisation here
    /*
     * allocateiobitmap(&H3B0, &H30, CPtr(Byte Ptr, &HFFFFFFFF))
     *    portalloc(&H3B0, &H30)
     * 
     *    allocatepagetable(CPtr(Byte Ptr, &H0), CPtr(Byte Ptr, -1))
     *    blockallocphys(32, CPtr(Byte Ptr, &HA0000), CPtr(Byte Ptr, &HA0000))
     * 
     *    Dim driver As GFXDRIVER2
     * 
     *    driver.Connectors = 1
     *    driver.Engines = 4 ' Alphanumeric, 16-color, 256-color, cursor
     *    driver.setconnectorstate = @VGA_ConnectorSetState
     *    driver.getconnectorstate = @VGA_ConnectorGetState
     *    driver.getconnectorrange = @VGA_ConnectorGetRange
     *    driver.setenginestate = @VGA_EngineSetState
     *    driver.getenginestate = @VGA_EngineGetState
     *    driver.getenginerange = @VGA_EngineGetRange
     *    driver.gldispatch = @VGA_GLDispatch
     * 
     *    Dim devid As Integer
     *    devid = DriverInit
     *    drv_setname(0,1)
     *    dim msg(0 to 1) As integer
     *    msg(0) = 7
     *    msg(1) = devid
     *    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )
     * 
     *    Write3C2(Read3C2() Or &H3) ' Use 3D4, make sure RAM is enabled
     *    VGAUnlockCRTC
     *    
     *    ' reset the Palette registers
     *    Dim c as Integer
     *    For c = 0 To 15
     *        Write3C0(c, c)
     *    Next c
     * 
     *    VGASetTextMode()
     *    VGAEnableDisplay
     *    outportb(&H3C8, 0)
     * 
     *    VGA_EngineDefaults() ' Load predefined settings
     * */
    
    outportb(0x3C2, inportb(0x3CC) | 0x3);
    VGAUnlockCRTC();
    for (int i = 0; i < 16; i++)
    {
        inportb(0x3DA);
        outportb(0x3C0, i);
        outportb(0x3C0, i); //pal[i] = i
    }
    VGASetTextMode();
    VGAEnableDisplay();
    
    VGA_EngineDefaults();
    udi_gfx_bind_ack(cb, 1, 4, 0);
}

void vga_gfx_unbind_req (udi_gfx_bind_cb_t *cb)
{
    
    udi_gfx_unbind_ack(cb);
}

void vga_gfx_set_engine_req (udi_gfx_state_cb_t *cb, udi_ubit32_t value)
{
    VGA_EngineSetState(NULL, cb->subsystem, cb->attribute, value);
    udi_gfx_set_engine_ack(cb);
}

void vga_gfx_set_connector_req (udi_gfx_state_cb_t *cb, udi_ubit32_t value)
{
    VGA_ConnectorSetState(NULL, cb->subsystem, cb->attribute, value);
    udi_gfx_set_connector_ack(cb);
}

void vga_gfx_get_engine_req (udi_gfx_state_cb_t *cb)
{
    udi_ubit32_t value = VGA_EngineGetState(NULL, cb->subsystem, cb->attribute);
    udi_gfx_get_engine_ack(cb, value);
}

void vga_gfx_get_connector_req (udi_gfx_state_cb_t *cb)
{
    udi_ubit32_t value = VGA_ConnectorGetState(NULL, cb->subsystem, cb->attribute);
    udi_gfx_get_connector_ack(cb, value);
}

static void vga_gfx_range_connector_req_2 (udi_cb_t *gcb, udi_buf_t * new_buf)
{
    bochs_puts("<a>");
    udi_gfx_range_cb_t *cb = UDI_MCB(gcb, udi_gfx_range_cb_t);
    bochs_puts("<b>");
    cb->rangedata = new_buf;
    bochs_puts("<c:0x");
    bochs_putu(new_buf->buf_size);
    bochs_puts(">");
    udi_gfx_range_connector_ack(cb);
    bochs_puts("<d>");
}

void vga_gfx_range_connector_req (udi_gfx_range_cb_t *cb)
{
    bochs_puts("<e>");
    udi_ubit32_t values[3] = {0, 0, 0};
    bochs_puts("<f>");
    if (VGA_ConnectorGetRange(NULL, cb->subsystem, cb->attribute, (int*) &(values[0]), (int*) &(values[1]), (int*) &(values[2])) == 0)
        values[2] = 0;
    bochs_puts("<g>");
    udi_buf_write(&vga_gfx_range_connector_req_2, UDI_GCB(cb), &(values[0]), 3 * sizeof(udi_ubit32_t), cb->rangedata, 0, 3 * sizeof(udi_ubit32_t), 0);
    bochs_puts("<h>");
}

void vga_gfx_range_engine_req (udi_gfx_range_cb_t *cb)
{
    bochs_puts("<i>");
    udi_ubit32_t values[3] = {0, 0, 0};
    bochs_puts("<j>");
    if (VGA_EngineGetRange(NULL, cb->subsystem, cb->attribute, (int*) &(values[0]), (int*) &(values[1]), (int*) &(values[2])) == 0)
        values[2] = 0;
    bochs_puts("<k>");
    udi_buf_write(&vga_gfx_range_connector_req_2, UDI_GCB(cb), &(values[0]), 3 * sizeof(udi_ubit32_t), cb->rangedata, 0, 3 * sizeof(udi_ubit32_t), 0);
    bochs_puts("<l>");
}

void vga_gfx_command_req (udi_gfx_command_cb_t *cb)
{
    // TODO: implement me properly    
    char * bytes = (char *) malloc(cb->commanddata->buf_size);
    udi_buf_read(cb->commanddata, 0, cb->commanddata->buf_size, bytes);
    VGA_GLDispatch(NULL, bytes, cb->commanddata->buf_size);
    free(bytes);
    udi_buf_free(cb->commanddata);
    udi_cb_free(UDI_GCB(cb));
}

// UDI structures: metalanguage entry
static const udi_gfx_provider_ops_t vga_gfx_provider_ops = {
    &vga_channel_event_ind,
    &vga_gfx_bind_req,
    &vga_gfx_unbind_req,
    &vga_gfx_set_connector_req,
    &vga_gfx_set_engine_req,
    &vga_gfx_get_connector_req,
    &vga_gfx_get_engine_req,
    &vga_gfx_range_connector_req,
    &vga_gfx_range_engine_req,
    &vga_gfx_command_req
};

// meta init
#define GFX_OPS_IDX       1
// fixme: is this the correct way?
#define VGA_GFX_META  1
static const udi_ops_init_t vga_ops_init_list[] = {
    {
        // should be the bus driver metalanguage
        0,
        0,
        0,
        0,
        (udi_ops_vector_t *)(void*)&vga_gfx_provider_ops,
        NULL   // todo: op_flags 
    },
    {
        GFX_OPS_IDX,          // todo: correct?
        VGA_GFX_META,     // meta index [from udiprops.txt]
        UDI_GFX_PROVIDER_OPS_NUM, // type of channel end
        0,                      // todo: no channel context
        (udi_ops_vector_t *)(void*)&vga_gfx_provider_ops,
        NULL   // todo: op_flags 
    },
    {
        0,  /* Terminator */
        0,
        0,
        0,
        NULL,
        NULL
    }
};

const udi_init_t udi_init_info = 
{
    NULL,               // todo: primary init //&udi_cmos_primary_init_info,
    NULL,               // todo: secondary init
    vga_ops_init_list,
    NULL,               // todo: cb init list //udi_cmos_cb_init_list,
    NULL,               // todo: gcb_init_list
    NULL                // todo: cb_select_list
};
