' Summary: vbe.bi
' The header for the VBE driver
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

Declare Function InitializeV8086() As Integer
Declare Sub Prepareinterrupt CDecl Alias "prepareinterrupt" (AX As Integer, CX As Integer, BX As Integer)
Declare Function RunInterrupt(ax as integer, cx as integer, bx as integer) As Byte

Declare Function VBE_Enumerate() As Integer

Type VBEMODE
    modenum As Integer
    xres As Integer
    yres As Integer
    bpp As Integer
    lfb As Byte Ptr
    pitch As Integer
End Type

Extern modecount As Integer
Extern modelist() As VBEMODE
Extern vmstub As Byte Ptr


Type VESA_INFO Field = 1
    signature As ZString * 4            ' 4 @ 00-03
    version As Short                    ' 2 @ 04-05
    OEMName_off As Unsigned Short       ' 4 @ 06-09
    OEMName_seg As Unsigned Short
    capabilities As Unsigned Integer    ' 4 @ 0A-0D
    modelist_off As Unsigned Short      ' 4 @ 0E-11
    modelist_seg As Unsigned Short
    vmem As Unsigned Short              ' 2 @ 12-13

    revision As Unsigned Short
    vendor_off As Unsigned Short
    vendor_seg As Unsigned Short
    product_off As Unsigned Short
    product_seg As Unsigned Short
    revstr_off As Unsigned Short
    revstr_seg As Unsigned Short
End Type

Type VESA_MODE Field = 1
   modeattributes As Unsigned Short
   winaattributes As Byte
   winbattributes As Byte
   wingranularity As Unsigned Short
   winsize As Unsigned Short
   winasegment As Unsigned Short
   winbsegment As Unsigned Short
   winfuncptr As Integer
   bytesperscanline As Unsigned Short

   ' Mandatory information for VBE 1.2 and above
   xresolution As Unsigned Short
   yresolution As Unsigned Short
   xcharsize As Byte
   ycharsize As Byte
   numberofplanes As Byte
   bitsperpixel As Byte
   numberofbanks As Byte
   memorymodel As Byte
   banksize As Byte
   numberofimagepages As Byte
   reserved1 As Byte

   ' Direct Color fields (required for direct/6 and YUV/7 memory models)
   redmasksize As Byte
   redfieldposition As Byte
   greenmasksize As Byte
   greenfieldposition As Byte
   bluemasksize As Byte
   bluefieldposition As Byte
   rsvdmasksize As Byte
   rsvdfieldposition As Byte
   directcolormodeinfo As Byte

   ' Mandatory information for VBE 2.0 and above
   physbaseptr As Byte Ptr
   offscreenmemoffset As Integer
   offscreenmemsize As Unsigned Short
End Type