' Summary: vbeenum.bas
' Generates a list of modes from VBE data
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "vbe.bi"

Dim Shared modelist() As VBEMODE
Dim Shared modecount As Integer

Function VBE_Enumerate() As Integer

    VBE_Enumerate = 0

    ' get VBE subsystem information
    Dim retval as Byte
    retval = RunInterrupt(&H4F00, 0, 0)
    if retval <> 1 Then Exit Function

    Dim vptr As VESA_INFO Ptr
    Dim vblock As VESA_INFO
    vptr = CPtr(VESA_INFO Ptr, @(vmstub[&H800])) ' the data starts at vm block + &H800
    vblock = vptr[0]

    ' check modelist sanity
    Dim enumaddress As Integer, maxenumbytes As Integer
    enumaddress = CInt(vblock.modelist_seg) * 16 + CInt(vblock.modelist_off)
    If (enumaddress >= CInt(vmstub) + &H800) And (enumaddress < CInt(vmstub) + &H1000) Then
        ' modelist follows the VBE data block
        maxenumbytes = CInt(vmstub) + &H1000 - enumaddress
    ElseIf (enumaddress >= &HC0000) And (enumaddress < &HD0000) Then
        ' modelist in (shadowed) ROM
        maxenumbytes = &HD0000 - enumaddress
    Else
        ' modelist pointer goes nowhere?
        Exit Function
    End If
    
    ' retrieve modelist

    ' sort modelist

    ' filter modelist


End Function

