' Summary: vbemon.bas
' VBE virtual mode monitor
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "mos.bi"
#include "vbe.bi"

' Variable: vmstub
' contains the location where the real mode stub is located
Dim Shared vmstub As Byte Ptr



' Function: InitializeV8086
' configures the environment to make Virtual8086 mode bios calls
'
' In:
'     none
'
' Out:
'     return - 1 on success, 0 if there were problems
'
Function InitializeV8086() As Integer

    dim vram as Byte Ptr, vbios as Byte Ptr, ivt as Unsigned Byte Ptr
    Dim ebda As Byte Ptr, pcbios As Byte Ptr

    Dim ebdaoffset As Long

    vram = CPtr(Byte Ptr, &HA0000)
    vbios = CPtr(Byte Ptr, &HC0000)
    ivt = CPtr(Unsigned Byte Ptr, &H0)
    vmstub = CPtr(Byte Ptr, &H10000)
    pcbios = CPtr(Byte Ptr, &HE0000)

    blockallocphys(32, vram, vram)
    blockallocphys(16, vbios, vbios)
    blockallocphys(1, ivt, ivt)
    blockallocphys(32, pcbios, pcbios)
    blockalloc(1, vmstub)

    ebdaoffset = 16 * CLng(ivt[&H40E]) + 256 * 16 * CLng(ivt[&H40F])
    ebda = CPtr(Byte Ptr, ebdaoffset and &HFF000)
    blockallocphys((&HA0000 - (ebdaoffset and &HFF000)) \ 4096, ebda, ebda)
    blockallocphys(16, ebda, ebda)

    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    allocateirbitmap(CPtr(Byte Ptr, &HFFFFFFFF))
    
    setredirectbits(0, 255, 0)

    vmstub[&H800] = ASC("V")
    vmstub[&H801] = ASC("B")
    vmstub[&H802] = ASC("E")
    vmstub[&H803] = ASC("2")

    InitializeV8086 = 1

End Function



' Function: RunInterrupt
' Calls a VBE interrupt
'
' In:
'     ax - the value for ax. Normally this is the function
'     cx - the value for cx
'     bx - the value for bx
'
' Out:
'     return - 1 on success, 0 when a privilege error occurred
'
Function RunInterrupt(ax as integer, cx as integer, bx as integer) As Byte
    Prepareinterrupt(ax, cx, bx)

    Dim vmdata As mos_v8086data
    vmdata.cs = &H1000
    vmdata.ip = 0
    vmdata.flags = &H202

    Dim vmptr As mos_v8086data Ptr
    vmptr = @vmdata

    Dim done As Byte, success As byte
    done = 0
    success = 0

    While done = 0
        enterv8086(vmptr)

        'PrintString "EnterV8086 returned:", 20, 14
        'PrintString ("CS: 0x" & hex$(vmdata.cs) & " IP: 0x" & hex$(vmdata.ip) & " DX: 0x" & hex$(vmdata.out_port) & " EFLAGS: 0x" & hex$(vmdata.flags) & " Stack: 0x" & hex$(vmdata.out_stack) & "        "), 21, 14
        dim codedump As Unsigned Byte Ptr
        codedump = CPtr(Unsigned Byte Ptr, 16 * vmdata.cs + vmdata.ip)

        ' handle the traps - check for relevant OUT/IN opcodes and map the desired ports.
        If ((codedump[0] >= &HEC) And (codedump[0] <= &HEF)) Or ((codedump[0] = &H66) And (codedump[1] >= &HEC) And (codedump[1] <= &HEF)) Then
            ' in al, dx; out dx, al; in *ax, dx; out dx, *ax
            portalloc(vmdata.out_port, 1)
            portalloc(vmdata.out_port+1, 1)
            portalloc(vmdata.out_port+2, 1)
            portalloc(vmdata.out_port+3, 1)
        ElseIf ((codedump[0] >= &HE4) And (codedump[0] <= &HE7)) Then
            ' in al, imm; out imm, al; in ax, imm; out imm, ax
            portalloc(codedump[1], 1)
            portalloc(codedump[1]+1, 1)
            portalloc(codedump[1]+2, 1)
            portalloc(codedump[1]+3, 1)
        ElseIf ((codedump[0] = &H66) And (codedump[1] >= &HE4) And (codedump[1] <= &HE7)) Then
            ' in eax, imm; out imm, eax
            portalloc(codedump[2], 1)
            portalloc(codedump[2]+1, 1)
            portalloc(codedump[2]+2, 1)
            portalloc(codedump[2]+3, 1)
        ElseIf (codedump[0] = &HCD) And (codedump[1] <= &HFF) Then
            ' int 0xff - this nonexistant interrupt gets called when we want to get out.
            done = 1
            success = 1
        Else
            done = 1
        End If

    Wend
    RunInterrupt = success
End Function

