; Summary: vesa_v8086.asm
; Realmode stub for setting up bios calls
;
; Author:
;     Marcel Sondaar
;
; License
;     <Public Domain>
;

%include "inc_ia.asm"

bits 32
SECTION .text
global prepareinterrupt

                    ;
                    ; Function: prepareinterrupt
                    ; Prepares a VESA bios call
                    ;
                    ; in:
                    ;     - Stack(1) = Value for AX
                    ;     - Stack(2) = Value for CX
                    ;     - Stack(3) = Value for BX
                    ;
                    ; out:
                    ;     none
                    ;
prepareinterrupt:   MOV EAX, [ESP+1*4]
                    MOV [v8086code.axpatch-2], AX
                    MOV EAX, [ESP+2*4]
                    MOV [v8086code.cxpatch-2], AX
                    MOV EAX, [ESP+3*4]
                    MOV [v8086code.bxpatch-2], AX
                    PUSH EDI
                    PUSH ESI
                    MOV ESI, v8086code
                    MOV EDI, 0x00010000
                    MOV ECX, v8086code.end - v8086code
                    CLD
                    REP MOVSB

                    POP ESI
                    POP EDI
                    RET


SECTION .data
bits 16

v8086code:          MOV AX, 0x1000
                    MOV SS, AX
                    MOV SP, 0x1000

                    ; ES:DI for get mode call
                    PUSH CS
                    POP ES
                    MOV DI, 0x800

                    XOR AX, AX
                    MOV FS, AX

                    mov ax, 1
                    mov ds, ax
                    mov ax, 3
                    mov gs, ax

                    mov dx, 0xbeeb
                    in al, dx

                    MOV AX, 0x4F00
.axpatch:           MOV CX, 0x0000
.cxpatch:           MOV BX, 0x0000
.bxpatch:

                    int 0x10
                    ;PUSH EFLAGS_IF
                    ;CALL FAR [FS:0x10*4]

                    JC .loop2
                    
.loop:              INT 0xFF
                    JMP .loop
.loop2:             INT 0xFE
                    JMP .loop2

.end
