' Summary: v2k_core.bas
' Core functionality for the Verite graphics adapter
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Educational Purposes>
'

#include "mos/gfx.bi"
#include "mos/bga_regs.bi"
#include "mos/drivercom.bi"
#include "mos/driver.bi"
#include "mos/pci.bi"
#include "mos.bi"
#include "x86.bi"

#include "GL/mgl.bi"
#include "GL/gl.bi"

Declare Function Verite_ConnectorSetState CDecl (info As Byte Ptr, index As Integer, prop As Integer, value As Integer) As Integer
Declare Function Verite_EngineSetState CDecl (info As Byte Ptr, index As Integer, prop As Integer, value As Integer) As Integer
Declare Function Verite_ConnectorGetState CDecl (info As Byte Ptr, index As Integer, prop As Integer) As Integer
Declare Function Verite_EngineGetState CDecl (info As Byte Ptr, index As Integer, prop As Integer) As Integer
Declare Function Verite_ConnectorGetRange CDecl (info As Byte Ptr, source As Integer, index As Integer, prop As Integer) As Integer
Declare Function Verite_EngineGetRange CDecl (info As Byte Ptr, source As Integer, index As Integer, prop As Integer) As Integer
Declare Function Verite_GLDispatch CDecl(ByVal info as Byte Ptr, ByVal data As Byte Ptr, ByVal length As Integer) As Integer

Declare Sub _gl_setoutput CDecl Alias "_gl_setoutput"(ByVal buffer As Byte Ptr, ByVal w As Integer, ByVal h As Integer, ByVal pitch As Integer)
Declare Sub _gl_inittextures CDecl Alias "_gl_inittextures" ()

Extern Verite_framebuffer As Byte Ptr
Extern Verite_ioaddr As Integer
Common Shared Verite_framebuffer As Byte Ptr
Common Shared Verite_ioaddr As Integer

Public Sub PrintString (s As String, vram As Byte Ptr, offset As Integer)
    Dim lp As Long
    Dim ch As Byte

    For lp = 1 To len(s)
        ch = asc(mid$(s,lp,1))
        vram[lp * 2 - 2 + 2 * offset] = ch
        vram[lp * 2 - 1 + 2 * offset] = 7
    Next lp
End Sub

Sub modmain CDecl Alias "main" (argc As Integer, argv As Byte Ptr Ptr)

    'I/O permission bitmap
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    portalloc(&HCF8, 8)
    'VGA RAM
    allocatepagetable(CPtr(Byte Ptr, &H0), CPtr(Byte Ptr, -1))
    blockallocphys(32, CPtr(Byte Ptr, &HA0000), CPtr(Byte Ptr, &HA0000))

    _gl_inittextures

    glMatrixMode GL_PROJECTION
    glLoadIdentity
    glMatrixMode GL_MODELVIEW
    glLoadIdentity
    glColor3f 1, 1, 1

    ' setup code here
    Dim devid As Integer
    devid = DriverInit      ' initialize driver, get device ID

    ' Get device location
    Dim devloc As String
    Dim devmsg(0 to 1) As Integer
    devmsg(0) = 10
    devmsg(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000, 8, CPtr(Byte Ptr, @(devmsg(0))))

    ' wait for response
    Dim Location As String
    While Location = ""
        While drv_peekmessage() = 0
            Yield
        Wend

        Dim rs As String
        rs = space$(drv_peekmessage())
        Dim rv As Integer
        rv = drv_readmessage(*CPtr(Byte Ptr Ptr, @rs))
        If rv = DRIVER_MGR * &H10000 Then
            '*CPtr(Short Ptr, &HB8006) = &H1F58
            location = rs
        End if
    Wend

    ' Todo: replace with a call to pciserv
    Dim bus as integer
    dim dev as integer
    dim dfn as integer
    bus = Valint("&H" & mid$(location,  5, 2))
    dev = Valint("&H" & mid$(location,  8, 2))
    dfn = Valint("&H" & mid$(location, 11, 2))

    Dim ioaddr As Integer
    Dim framebuffer As Byte Ptr
    Dim bar As Integer

    PrintString "PCI: " & hex$(bus) & ":" & hex$(dev) & ":" & hex$(dfn) & " " & hex$(pci_type1_readdword(bus,dev,dfn,0)), CPtr(Byte Ptr, &HB8000), 80
    PrintString location, CPtr(Byte Ptr, &HB8000), 320

    Dim i As Integer
    For i = &H10 to &H1C Step 4
        bar = pci_type1_readdword(bus, dev, dfn, i)
        PrintString "bar @ 0x" & hex$(i) & " = 0x" & hex$(bar), CPtr(Byte Ptr, &HB8000), 400 + 20 * (i - 16)
        If (Bar <> 0) And ((bar and &HFFFF0) = 0) And (framebuffer = CPtr(Byte Ptr, 0)) Then
            framebuffer = CPtr(Byte Ptr, (bar and &HFFFF0000))
        ElseIf (Bar <> 0) And (bar and &H1) = 1 Then
            ioaddr = Bar And &HFFF0
        End If
    Next i

    PrintString "ioaddr: " & hex$(ioaddr), CPtr(Byte Ptr, &HB8000), 160
    PrintString "fbaddr: " & hex$(framebuffer), CPtr(Byte Ptr, &HB8000), 240

    ' Allocate hardware resources
    Portalloc(ioaddr, 256)
    '*CPtr(Short Ptr, &HB800E) = &H0941
    ManageMemoryL2(CPtr(Byte Ptr, &HFFFFFFFF), framebuffer)
    '*CPtr(Short Ptr, &HB800E) = &H0A42
    Verite_framebuffer = CPtr(Byte Ptr, &H60000000)
    '*CPtr(Short Ptr, &HB800E) = &H0B43
    BlockAllocPhysL(1, Verite_framebuffer, framebuffer)
    '*CPtr(Short Ptr, &HB800E) = &H0C44
    Verite_ioaddr = ioaddr

    ' register driver in device manager
    drv_setname(0,1)
    dim msg(0 to 1) As integer
    msg(0) = 7
    msg(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )

    _gl_setoutput(Verite_framebuffer, 640, 480, 640*4)

    Dim driver As GFXDRIVER2
    driver.Connectors = 1
    driver.Engines = 14 ' 8bpp, 16bpp, 24bpp, 32bpp, 15bpp, 1bpp
    driver.setconnectorstate = @Verite_ConnectorSetState
    driver.getconnectorstate = @Verite_ConnectorGetState
    driver.getconnectorrange = @Verite_ConnectorGetRange
    driver.setenginestate = @Verite_EngineSetState
    driver.getenginestate = @Verite_EngineGetState
    driver.getenginerange = @Verite_EngineGetRange
    driver.gldispatch = @Verite_GLDispatch

    graphicsmain2(driver, CPtr(Byte Ptr, 0))

End Sub

