' Summary: v2k_func.bas
' Engine and Socket control for the Verite driver
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Educational Purposes>
'
#include "mos/gfx.bi"
#include "verite.bi"
#include "mos/drivercom.bi"
#include "mos/driver.bi"
#include "mos/pci.bi"
#include "mos.bi"
#include "x86.bi"

#include "GL/mgl.bi"
#include "GL/gl.bi"
#include "swgl/glbuffer.bi"
#include "../opcodetool.bi"

Type ConnectorState
    Enabled as Integer
    Input As Integer
    BitDepth As Integer
    Width As Integer
    Height As Integer
End Type

Dim Shared connector As ConnectorState

Type EngineState
    Enabled As Integer
    Width As Integer
    operatorindex As Integer
    OpcodeMap As UDIOpcodeMap Ptr
    Height As Integer
    VWidth As Integer
    Xoff As Integer
    Yoff As Integer
End Type

Dim Shared engines(0 to 4) As EngineState

Extern Verite_framebuffer As Byte Ptr
Extern Verite_ioaddr As Integer

Sub Verite_Defaults CDecl()
    engines(0).OpcodeMap = @opcodemap_b8g8r8x8
    engines(4).OpcodeMap = @opcodemap_b8g8r8x8

    engines(1).OpcodeMap = @opcodemap_b5g6r5
    engines(2).OpcodeMap = @opcodemap_b8g8r8x8
    engines(3).OpcodeMap = @opcodemap_b5g5r5
End Sub

Function Verite_ConnectorSetState CDecl (info As Byte Ptr, index As Integer, prop As Integer, value As Integer) As Integer

    Function = 0
    If index <> 0 Then Exit Function

    Select Case prop
        Case GFX_PROP_ENABLE

            if value = 1 Then
                
                ' Let the card do LE-BE conversion for us                

                Dim memendian As Integer
                memendian = 0

                ' native mode
                'outportb Verite_ioaddr + VREGS.VERITE_MODE, 1
                inportb Verite_ioaddr + VREGS.VERITE_MODE
                ' CRTC config
                outportd Verite_ioaddr + VREGS.VERITE_CRTCH, &H002B0A4F
                outportd Verite_ioaddr + VREGS.VERITE_CRTCV, &H009301DF
                inportb Verite_ioaddr + VREGS.VERITE_MODE
                ' crtc black magic
                outportd Verite_ioaddr + VREGS.VERITE_WIDTH, 128
                inportb Verite_ioaddr + VREGS.VERITE_MODE
                outportd Verite_ioaddr + &H94, &H0
                inportb Verite_ioaddr + VREGS.VERITE_MODE
                ' dramctl black magic
                Dim lp As Long
                lp = inportd(Verite_ioaddr + &HA0)
                lp = (lp and &HC7FF&) Or &H330000
                outportd(Verite_ioaddr + &HA0, lp)
                inportb Verite_ioaddr + VREGS.VERITE_MODE
                ' 32 bit DAC
                outportb Verite_ioaddr + VREGS.VERITE_DAC_CR0, &H82 ' access enable, 8-bit DAC
                inportb Verite_ioaddr + VREGS.VERITE_MODE
                Dim crtformat As Integer
                Select case connector.Input
                    ' this one seems to work, but needs palette support
                    Case 0 ' 8bpp
                        outportb Verite_ioaddr + VREGS.VERITE_DAC_CR1, &H40 ' 8 bpp, palette enabled, 565 mode
                        crtformat = 1
                        _gl_backbuffer->writebuffer = @_gl_writebuffer_i8
                        _gl_backbuffer->fillbuffer = @_gl_fillbuffer_i8
                        memendian = 1
                    ' these work...
                    Case 1 ' 16bpp
                        outportb Verite_ioaddr + VREGS.VERITE_DAC_CR1, &H38 ' 16 bpp, no palette, 565 mode
                        crtformat = 4
                        _gl_backbuffer->writebuffer = @_gl_writebuffer_b5g6r5
                        _gl_backbuffer->fillbuffer = @_gl_fillbuffer_b5g6r5
                        memendian = 3
                    Case 2 ' 32bpp
                        outportb Verite_ioaddr + VREGS.VERITE_DAC_CR1, &H10 ' 24 bpp, no palette
                        crtformat = 12
                        _gl_backbuffer->writebuffer = @_gl_writebuffer_b8g8r8x8
                        _gl_backbuffer->fillbuffer = @_gl_fillbuffer_b8g8r8a8
                        memendian = 0
                    Case 3 ' 15bpp
                        outportb Verite_ioaddr + VREGS.VERITE_DAC_CR1, &H30 ' 16 bpp, no palette, 555 mode
                        crtformat = 6
                        _gl_backbuffer->writebuffer = @_gl_writebuffer_b5g5r5
                        _gl_backbuffer->fillbuffer = @_gl_fillbuffer_b5g5r5  
                        memendian = 3

                    ' weird stuff - not supported by the CRTC, maybe for conversion by the GPU?                    
                    Case 4 ' 4bpp?
                        outportb Verite_ioaddr + VREGS.VERITE_DAC_CR1, &H60 ' 4 bpp, palette enabled, 565 mode
                        crtformat = 1
                    Case 5 ' 1bpp?
                        outportb Verite_ioaddr + VREGS.VERITE_DAC_CR1, &H80 ' 1 bpp, palette enabled
                        crtformat = 2
                    Case 6 ' 12bpp?
                        outportb Verite_ioaddr + VREGS.VERITE_DAC_CR1, &H30 ' 16 bpp, no palette
                        crtformat = 5
                    Case 7 'test
                        outportb Verite_ioaddr + VREGS.VERITE_DAC_CR1, &H40 ' 8 bpp, palette enabled
                        crtformat = 2
                    Case 8 'test
                        outportb Verite_ioaddr + VREGS.VERITE_DAC_CR1, &H50 ' 8 bpp, palette disabled
                        crtformat = 1
                    Case 9 'untested
                        outportb Verite_ioaddr + VREGS.VERITE_DAC_CR1, &H18 ' 32 bpp, no palette, 565 mode
                        crtformat = 7
                    Case 10 'untested
                        outportb Verite_ioaddr + VREGS.VERITE_DAC_CR1, &H18 ' 32 bpp, no palette, 565 mode
                        crtformat = 8
                    Case 11 'untested
                        outportb Verite_ioaddr + VREGS.VERITE_DAC_CR1, &H18 ' 32 bpp, no palette, 565 mode
                        crtformat = 9
                    Case 12 'untested
                        outportb Verite_ioaddr + VREGS.VERITE_DAC_CR1, &H18 ' 32 bpp, no palette, 565 mode
                        crtformat = 10

                    Case 13 'yuyv?
                        outportb Verite_ioaddr + VREGS.VERITE_DAC_CR1, &H30 ' 16 bpp
                        crtformat = 13
                End Select
                
                Do
                    outportb(Verite_ioaddr + VREGS.VERITE_MEMENDIAN, memendian)
                Loop until inportb(Verite_ioaddr + VREGS.VERITE_MEMENDIAN) = memendian

                inportb Verite_ioaddr + VREGS.VERITE_MODE
                outportb Verite_ioaddr + VREGS.VERITE_DAC_CR2, &H20 ' black magic
                inportb Verite_ioaddr + VREGS.VERITE_MODE
                outportb Verite_ioaddr + VREGS.VERITE_DAC_PIXELMASK, &HFF ' enable all pixels
                inportb Verite_ioaddr + VREGS.VERITE_MODE

                outportd Verite_ioaddr + VREGS.VERITE_FRAMESTART, 0 ' index 0

                ' enable output, select pixel encoding
                outportd Verite_ioaddr + VREGS.VERITE_CRTCCTL, &H1C10 + crtformat
                inportb Verite_ioaddr + VREGS.VERITE_MODE

                _gl_setoutput(Verite_framebuffer, 640, 480, 320 * ((connector.bitdepth + 1) SHR 2) )

                connector.Enabled = 1
            Else
                outportd Verite_ioaddr + VREGS.VERITE_CRTCCTL, 0
                connector.Enabled = 0
            End if

        Case GFX_PROP_INPUT
            If connector.Enabled = 1 Then Exit Function
            If value < 0 then Exit Function
            'If value > 3 then Exit Function ' uncomment to disable trickery
            If value > 13 then Exit Function
            connector.Input = value
            connector.bitdepth = 8 SHL value
            if value = 3 Then connector.bitdepth = 15
            if value = 4 Then connector.bitdepth = 1
            if value > 4 Then connector.bitdepth = 16

        Case GFX_PROP_WIDTH
            '*CPtr(Short Ptr, &HB8024) = &H1F41

        Case GFX_PROP_HEIGHT
            '*CPtr(Short Ptr, &HB8026) = &H1F41

    End Select

End Function
Function Verite_ConnectorGetState CDecl (info As Byte Ptr, index As Integer, prop As Integer) As Integer
    Function = 0
    If index <> 0 Then Exit Function

    Select Case prop
        Case GFX_PROP_ENABLE
            Function = connector.Enabled

        Case GFX_PROP_INPUT
            Function = connector.Input

        Case GFX_PROP_WIDTH
            Function = connector.Width

        Case GFX_PROP_HEIGHT
            Function = connector.Height

        Case GFX_PROP_SIGNAL:
            Function = GFX_SIGNAL_RGBHV

        Case GFX_PROP_CONNECTOR_TYPE
            Function = GFX_CONNECTOR_VGA

    End Select
End Function
Function Verite_ConnectorGetRange CDecl (info As Byte Ptr, source As Integer, index As Integer, prop As Integer) As Integer
    If index = 0 Then
        Function = 1
        Select case prop
            Case GFX_PROP_ENABLE
                ConnectorReturnBooleanRange(source, index, prop, 0, 1)
            Case GFX_PROP_INPUT
                ConnectorReturnSimpleRange(source, index, prop, 0, 13, 1)
            Case GFX_PROP_WIDTH
                ConnectorReturnSimpleRange(source, index, prop, 320, 1024, 8)
            Case GFX_PROP_HEIGHT
                ConnectorReturnSimpleRange(source, index, prop, 240, 768, 8)
            Case GFX_PROP_SIGNAL
                ConnectorReturnConstantRange(source, index, prop, GFX_SIGNAL_RGBHV)
            Case GFX_PROP_CONNECTOR_TYPE
                ConnectorReturnConstantRange(source, index, prop, GFX_CONNECTOR_VGA)

            Case Else
                Function = 0
        End select
    Else
        Function = 0
    End If
End Function

Function Verite_EngineSetState CDecl (info As Byte Ptr, index As Integer, prop As Integer, value As Integer) As Integer
    If index < 0 Or index > 4 Then Exit Function
    Select case prop
        Case GFX_PROP_TRANSLATEX
            If value < 0 Then Value = 0
            engines(index).xoff = value
            If connector.input = index Then outportd Verite_ioaddr + VERITE_FRAMESTART, (engines(index).xoff + connector.width * engines(index).yoff) * CInt(connector.bitdepth / 8)
        Case GFX_PROP_TRANSLATEY
            If value < 0 Then Value = 0
            engines(index).yoff = value
            If connector.input = index Then outportd Verite_ioaddr + VERITE_FRAMESTART, (engines(index).xoff + connector.width * engines(index).yoff) * CInt(connector.bitdepth / 8)
        Case GFX_PROP_OPERATOR_INDEX
            engines(index).operatorindex = value
    End Select
    Function = 0
End Function

Function Verite_EngineGetState CDecl (info As Byte Ptr, index As Integer, prop As Integer) As Integer
    Function = 0
    If (index < 0) or (index > 3) Then Exit Function
    Select Case prop
        'Case GFX_PROP_ENABLE
        Case GFX_PROP_INPUT
            Function = -1
        'Case GFX_PROP_WIDTH
        'Case GFX_PROP_HEIGHT
        'Case GFX_PROP_CLIP
        Case GFX_PROP_UNIT_WIDTH
            Function = 1
        Case GFX_PROP_UNIT_HEIGHT
            Function = 1
        Case GFX_PROP_TILESHEET
            Function = 0
        Case GFX_PROP_PALETTE
            If index = 0 Then
                Function = 2
            Else
                Function = 0
            End If
        Case GFX_PROP_BUFFER
            Function = 1
        'Case GFX_PROP_TRANSLATEX = 10            
        'Case GFX_PROP_TRANSLATEY = 11        

        Case GFX_PROP_SOURCE_WIDTH
            Function = 1
        Case GFX_PROP_SOURCE_HEIGHT
            Function = 1
        Case GFX_PROP_OPERATOR_INDEX, GFX_PROP_OPERATOR_OPCODE, GFX_PROP_OPERATOR_ARG_1, GFX_PROP_OPERATOR_ARG_2, GFX_PROP_OPERATOR_ARG_3
            Function = readopcodemap(engines(index).OpcodeMap, prop, engines(index).operatorindex)

    End Select
End Function
Function Verite_EngineGetRange CDecl (info As Byte Ptr, source As Integer, index As Integer, prop As Integer) As Integer
    Function = 0
    If (index < 0) or (index > 3) Then Exit Function
    Function = 1
    Select Case prop
        'Case GFX_PROP_ENABLE
        Case GFX_PROP_INPUT
            EngineReturnConstantRange(source, index, prop, -1)
        'Case GFX_PROP_WIDTH
        'Case GFX_PROP_HEIGHT
        'Case GFX_PROP_CLIP
        Case GFX_PROP_UNIT_WIDTH
            EngineReturnConstantRange(source, index, prop, 1)
        Case GFX_PROP_UNIT_HEIGHT
            EngineReturnConstantRange(source, index, prop, 1)
        Case GFX_PROP_TILESHEET
            EngineReturnConstantRange(source, index, prop, 0)
        Case GFX_PROP_PALETTE
            EngineReturnConstantRange(source, index, prop, IIf(index = 0, 2, 0))
        Case GFX_PROP_BUFFER
            EngineReturnConstantRange(source, index, prop, 1)
        'Case GFX_PROP_TRANSLATEX = 10
        'Case GFX_PROP_TRANSLATEY = 11

        Case GFX_PROP_SOURCE_HEIGHT
            EngineReturnConstantRange(source, index, prop, 1)
        Case GFX_PROP_SOURCE_WIDTH
            EngineReturnConstantRange(source, index, prop, 1)

        Case GFX_PROP_OPERATOR_INDEX, GFX_PROP_OPERATOR_OPCODE, GFX_PROP_OPERATOR_ARG_1, GFX_PROP_OPERATOR_ARG_2, GFX_PROP_OPERATOR_ARG_3
            Dim start As Integer, endval As Integer
            readopcodemaprange(engines(index).OpcodeMap, prop, engines(index).operatorindex, start, endval)
            EngineReturnSimpleRange(source, index, prop, start, endval, 1)
        Case Else
            Function = 0
    End Select
End Function

Function Verite_GLDispatch CDecl(ByVal info as Byte Ptr, ByVal buffer As Byte Ptr, ByVal length As Integer) As Integer
    If mglDispatchInstruction(buffer, length) = 0 Then
        if length = 8 Then
            If CPtr(Short Ptr, buffer)[1] = 4000 Then
                ' flip screen
            End If
        end if
        Function = 0
    Else
        Function = 1
    End if
End Function
