/* Summary: vgacommand.c
 * Handles VGA commands
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Educational Purposes>
 */

#include "vgaif.h"
#include "../vga_io.h"
#include <GL/gl.h>
#include <GL/glx_opcodes.h>

typedef union
{
    const void * raw;
    const GLshort * shortargs;
    const GLint * intargs;
    const GLuint * uintargs;
    const GLfloat * floatargs;
    const GLdouble * doubleargs;
} _GLX_READBUFFER;

static int current_buffer = 1;

int VGA_GLDispatch (void * info, void * buffer, int length)
{
    if (length < 4) return 0;
    if (info) {} // TODO: separate state

    _GLX_READBUFFER data;
    data.raw = buffer;

    int oplength = data.shortargs[0];
    int opcode = data.shortargs[1];
    if (oplength > length) return 0;

    switch (opcode)
    {
        case GLOP_TEXSUBIMAGE2D:
            VGA_glTexSubImage2D(data.intargs[1], data.intargs[2], data.intargs[3], data.intargs[4],
                                data.intargs[5], data.intargs[6], data.intargs[7], data.intargs[8],
                                (void *)&(data.intargs[9]));
            break;

        case GLOP_BINDBUFFERUDI:
            if ((data.intargs[2] == 1 || data.intargs[2] == 2) && data.intargs[1] == GL_BUFFER_2D)
                current_buffer = data.intargs[2];

            break;

        default:
            return 0;

    }
    return 1;
}

/*
 */
void VGA_glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels )
{
    //*(char *)0 = 0;

    if (target != GL_BUFFER_2D) return;
    if (level != 0) return;
    if (current_buffer == 2)
    {
        VGA_WritePalette(xoffset, yoffset, width, height, format, type, pixels, (void*)0);
        return;
    }
    if (format != GL_COLOR_INDEX) return; // Fixme: should support more
    if (type != GL_BYTE && type != GL_UNSIGNED_BYTE) return;

    switch (socket.input)
    {
        case 0:
        case 3:
            // text mode
            break;

        case 1:
            {
                Write3C4(8, 255);
                // 4bpp mode
                int blockstart = (xoffset + 7) >> 3;
                int blockend = (xoffset + width - 8) >> 3;
                int leftdiff = xoffset & 0x7;
                int rightdiff = (xoffset + width - 8) & 0x7;
                for (int p = 0; p < 4; p++)
                {
                    int bit = 1 << p;
                    Write3C4(0x02, bit);
                    // write full blocks
                    unsigned char * pix_in = (unsigned char *) pixels;
                    for (int y = yoffset; y < yoffset + height; y++)
                    {
                        unsigned char * pix_out = (unsigned char *) 0xA0000 + blockstart + ((engines[1].width * y) >> 3);
                        pix_in += leftdiff;
                        for (int x = blockstart; x <= blockend; x++)
                        {
                            unsigned char write_bits = 0;
                            unsigned char wbit = 128;
                            for (int seg = 0; seg < 8; seg++)
                            {
                                write_bits |= (*pix_in & bit) ? wbit : 0;
                                wbit >>= 1;
                                pix_in++;
                            }
                            *pix_out = write_bits;
                            pix_out++;
                        }
                        pix_in += rightdiff;
                    }
                    // todo: write spare blocks
                    if (leftdiff)
                    {
                    }
                    
                    if (rightdiff)
                    {
                    }  
                }
            }
            break;


        case 2:
            // 8bpp mode
            for (int p = 0; p < 4; p++)
            {
                Write3C4(0x02, 1 << p);
                int xstart = (xoffset & 0xfffc) + p;
                if (xstart < xoffset) xstart += 4;
                for (int y = yoffset; y < yoffset+height; y++)
                {
                    unsigned char * pix_in = (unsigned char *) pixels;
                    //pix_in += (xstart - xoffset);
                    unsigned int pix_off = (xstart >> 2) + ((engines[2].width * y) >> 3);
                    unsigned char * pix_out = (unsigned char *) 0xA0000;
                    pix_in += (y-yoffset) * width + (xstart - xoffset);
                    for (int x = xstart; x < xoffset + width; x += 4)
                    {
                        pix_out[pix_off & 0xffff] = *pix_in;
                        pix_in += 4;
                        pix_off++;
                    }
                }
            }

            break;

        default:
            break;
    }


}
