/* Summary: vgaengine.c
 * Handles VGA Engine states
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Educational Purposes>
 */

#define UDI_GFX_VERSION 0x101
#define UDI_VERSION 0x101

#include "vgaif.h"
#include "../vga_io.h"
#include <udi_gfx.h>

VGAENGINESTATE enginedata[4];
VGAENGINESTATE * engines = &(enginedata[0]);

int VGA_EngineSetState (void * info, int index, int prop, int value)
{
    if (info) if (index) if (prop) if (value) {} // TODO: implement me
    return 0;
}

int VGA_EngineGetState (void * info, int index, int prop)
{
    if (index < 0 || index > 3) return 0;
    if (info) {} // TODO: separate state

    switch(prop)
    {
        case UDI_GFX_PROP_ENABLE:           return enginedata[index].enabled;
        case UDI_GFX_PROP_INPUT:            return enginedata[index].input;
        case UDI_GFX_PROP_WIDTH:            return enginedata[index].width;
        case UDI_GFX_PROP_HEIGHT:           return enginedata[index].height;

        case UDI_GFX_PROP_CLIP:             return enginedata[index].clip;
        case UDI_GFX_PROP_UNIT_WIDTH:       return enginedata[index].tile_w;
        case UDI_GFX_PROP_UNIT_HEIGHT:      return enginedata[index].tile_h;
        case UDI_GFX_PROP_TILESHEET:        return ((index == 0) ? 3 : 0); // only text mode has a tilesheet attached
        case UDI_GFX_PROP_PALETTE:          return 2;
        case UDI_GFX_PROP_BUFFER:           return 1;
        case UDI_GFX_PROP_TRANSLATEX:       return enginedata[index].off_x;
        case UDI_GFX_PROP_TRANSLATEY:       return enginedata[index].off_y;
        case UDI_GFX_PROP_STORE_WIDTH:      return ((index == 1) ? 8  : 1);
        case UDI_GFX_PROP_STORE_HEIGHT:     return 1;
        case UDI_GFX_PROP_STORE_BITS:       return enginedata[index].store_bits;
        case UDI_GFX_PROP_SOURCE_HEIGHT:    return ((index == 0) ? enginedata[index].tile_h : 1);
        case UDI_GFX_PROP_SOURCE_WIDTH:     return ((index == 0) ? 8 : 1);

        default:
            return 0;
    }
}

int VGA_EngineGetRange (void * info, int index, int prop, int * startval, int * endval, int * modval)
{
    if (index < 0) return 0;
    if (index > 3) return 0;
    if (info) {} // TODO: separate state

    switch (prop)
    {
        case UDI_GFX_PROP_ENABLE:
            *startval = 1;
            *endval = 1;
            *modval = 1;
            break;
        case UDI_GFX_PROP_INPUT:
            if (index == 3)
            {
                *startval = 0;
                *endval = 0;
                *modval = 1;
            }
            else
            {
                *startval = -1;
                *endval = -1;
                *modval = 1;
            }
            break;



        default:
            return 0;
    }
    return 1;
}

void VGA_EngineDefaults(void)
{
    for (int i = 0; i < 4; i++)
    {
        enginedata[i].enabled = 1;
        enginedata[i].height = 400;
        enginedata[i].connected = 0;
        enginedata[i].input = -1;
        enginedata[i].clip = 2;
        enginedata[i].off_x = 0;
        enginedata[i].off_y = 0;
    }
    enginedata[0].width = 720;
    enginedata[1].width = 640;
    enginedata[2].width = 640;
    enginedata[3].width = 9;
    enginedata[3].height = 16; // character height by default
    enginedata[3].input = 0;   // cursor over framebuffer
    enginedata[0].tile_w = 9;
    enginedata[1].tile_w = 1;
    enginedata[2].tile_w = 2;  // two nibbles interpreted as one pixel
    enginedata[3].tile_w = 9;
    enginedata[0].tile_h = 16;
    enginedata[1].tile_h = 1;
    enginedata[2].tile_h = 2;  // doublescan by default
    enginedata[3].tile_h = 16;
    enginedata[3].clip = 0;    // cursor is passthru outside its bounds
    enginedata[0].store_bits = 16; // text mode takes 16 bits/tile
    enginedata[1].store_bits = 32; // 16-color mode: 32 bits for 8 pixels
    enginedata[2].store_bits = 8;  // 8bpp
    enginedata[3].store_bits = 0;  // no info stored for cursor
}
