/* Summary: vgaif.h
 * Defines the VGA interfaces
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Educational Purposes>
 */
#ifndef __VGAIF_H__
#define __VGAIF_H__

#include <GL/gl_types.h>
#include <swgl/glbuffer.h>

// gfx bindings
int VGA_ConnectorSetState (void * info, int index, int prop, int value);
int VGA_ConnectorGetState (void * info, int index, int prop);
int VGA_ConnectorGetRange (void * info, int index, int prop, int * startval, int * endval, int * modval);
int VGA_EngineSetState (void * info, int index, int prop, int value);
int VGA_EngineGetState (void * info, int index, int prop);
int VGA_EngineGetRange (void * info, int index, int prop, int * startval, int * endval, int * modval);
int VGA_GLDispatch (void * info, void * buffer, int length);
// required commands
void VGA_glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
void VGA_glBindBuffer(GLenum target, GLuint buffer);
void VGA_WritePalette(GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels, GLbuffer * dest);

void VGA_EngineDefaults(void);

typedef struct VGAENGINESTATE
{
    int enabled;
    int connected;
    int input;
    int width;
    int height;
    int tile_w;
    int tile_h;
    int tilesheet;
    int clip;
    int off_x;
    int off_y;
    int store_bits;
} VGAENGINESTATE;

typedef struct VGACONNECTORSTATE
{
    int input;
    int enabled;
    int width;
    int height;
    int os_l;
    int os_r;
    int os_t;
    int os_b;
    int blank_l;
    int blank_r;
    int blank_t;
    int blank_b;
    int h_sync;
    int v_sync;
    int hmod;
    int clock;
} VGACONNECTORSTATE;

extern VGAENGINESTATE * engines;
extern VGACONNECTORSTATE socket;

#endif
