/* Summary: vgapalette.c
 * Writing functions for the VGA palette
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include "vgaif.h"

#include <x86.h>
#include <GL/gl.h>
#include <stdlib.h>
//#include <swgl/gltexture.h>
#include <swgl/glbuffer.h>

static GLubyte popdata(GLubyte ** readptr, GLenum type)
{
    GLubyte * ptr = *readptr;
    switch(type)
    {
        case GL_BYTE:
            readptr++;
            if (*((GLbyte *) ptr) < 0) return 0;
            return *((GLbyte *) ptr);

        case GL_UNSIGNED_BYTE:
            readptr++;
            return *ptr;

        case GL_UNSIGNED_SHORT:
            readptr += 2;
            if (*((GLushort *) ptr) > 255) return 255;
            return *((GLushort *) ptr);

        case GL_SHORT:
            readptr += 2;
            if (*((GLshort *) ptr) < 0)   return 0;
            if (*((GLshort *) ptr) > 255) return 255;
            return *((GLshort *) ptr);

        case GL_UNSIGNED_INT:
            readptr += 4;
            if (*((GLuint *) ptr) > 255) return 255;
            return *((GLuint *) ptr);

        case GL_INT:
            readptr += 4;
            if (*((GLint *) ptr) < 0)   return 0;
            if (*((GLint *) ptr) > 255) return 255;
            return *((GLint *) ptr);

        case GL_FLOAT:
            readptr += 4;
			return 0;
			
		default:
			return 0;

    }
    return 0;
}

void VGA_WritePalette(GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels, GLbuffer * dest)
{
	if (dest) {}
	
    int x, y;

    GLint outwidth = 256;

    if (xoffset < 0) return;
    if (yoffset < 0) return;
    if (xoffset + width > outwidth) return;
    if (yoffset + height > 1) return;
    
    outportb(0x3C8, xoffset);

    GLubyte * inptr = (GLubyte *) pixels;

    // sort out common cases before doing the slow brute-force thing
    if (format == GL_RGB && type == GL_UNSIGNED_BYTE)
    {
        for (y = 0; y < height; y++)
        {
            for (x = 0; x < width; x++)
            {
                outportb(0x3c9, (*inptr++) >> 2);
                outportb(0x3c9, (*inptr++) >> 2);
                outportb(0x3c9, (*inptr++) >> 2);
            }
        }
    }
    else if (format == GL_RGBA && type == GL_UNSIGNED_BYTE)
    {
        for (y = 0; y < height; y++)
        {
            for (x = 0; x < width; x++)
            {
                outportb(0x3c9, (*inptr++) >> 2);
                outportb(0x3c9, (*inptr++) >> 2);
                outportb(0x3c9, (*inptr++) >> 2);
                inptr++;
            }
        }
    }
    else if (format == GL_COLOR_INDEX && (type == GL_UNSIGNED_BYTE || type == GL_BYTE))
    {
        for (y = 0; y < height; y++)
        {
            for (x = 0; x < width; x++)
            {
                GLubyte v = (*inptr++) >> 2;
                outportb(0x3c9, v);
                outportb(0x3c9, v);
                outportb(0x3c9, v);
            }
        }
    }
    else
    {
        for (y = 0; y < height; y++)
        {
            for (x = 0; x < width; x++)
            {
                switch(format)
                {
                    case GL_RED:
                        outportb(0x3c9, popdata(&inptr, type) >> 2);
                        outportb(0x3c9, 0);
                        outportb(0x3c9, 0);
                        break;

                    case GL_GREEN:
                        outportb(0x3c9, 0);
                        outportb(0x3c9, popdata(&inptr, type) >> 2);
                        outportb(0x3c9, 0);
                        break;

                    case GL_BLUE:
                        outportb(0x3c9, 0);
                        outportb(0x3c9, 0);
                        outportb(0x3c9, popdata(&inptr, type) >> 2);
                        break;

                    case GL_ALPHA:
                        outportb(0x3c9, 0);
                        outportb(0x3c9, 0);
                        outportb(0x3c9, 0);
                        popdata(&inptr, type);
                        break;

                    case GL_RGB:
                        outportb(0x3c9, popdata(&inptr, type) >> 2);
                        outportb(0x3c9, popdata(&inptr, type) >> 2);
                        outportb(0x3c9, popdata(&inptr, type) >> 2);
                        break;

                    case GL_RGBA:
                        outportb(0x3c9, popdata(&inptr, type) >> 2);
                        outportb(0x3c9, popdata(&inptr, type) >> 2);
                        outportb(0x3c9, popdata(&inptr, type) >> 2);
                        popdata(&inptr, type);
                        break;

                    case GL_LUMINANCE:
                        {
                            GLubyte data = popdata(&inptr, type) >> 2;
                            outportb(0x3c9, data);
                            outportb(0x3c9, data);
                            outportb(0x3c9, data);
                        }
                        break;

                    case GL_LUMINANCE_ALPHA:
                        {
                            GLubyte data = popdata(&inptr, type) >> 2;
                            outportb(0x3c9, data);
                            outportb(0x3c9, data);
                            outportb(0x3c9, data);
                            popdata(&inptr, type);
                        }
                        break;

                    case GL_COLOR_INDEX:
                        break;
						
					default:
						break;
                }
            }
        }
    }
}
