' Summary: vga_core.bas
' Core functionality for the IBM VGA
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Educational Purposes>
'

#include "mos/gfx.bi"
#include "mos/driver.bi"
#include "mos/drivercom.bi"
#include "vga_io.bi"
#include "vga/vgaif.bi"
#include "mos.bi"
#include "x86.bi"

#include "GL/mgl.bi"
#include "GL/gl.bi"

Function VGA_PatchConnectorGetRange CDecl (ByVal info As Byte Ptr, ByVal sender As Integer, ByVal index As Integer, ByVal prop As Integer) As Integer
    Dim startval As Integer, endval As Integer, modval As Integer, retval As Integer
    retval = VGA_ConnectorGetRange(info, index, prop, startval, endval, modval)
    If (retval = 1) Then
        ConnectorReturnSimpleRange(sender, index, prop, startval, endval, modval)
    End If
    Function = retval
End Function

Function VGA_PatchEngineGetRange CDecl (ByVal info As Byte Ptr, ByVal sender As Integer, ByVal index As Integer, ByVal prop As Integer) As Integer
    Dim startval As Integer, endval As Integer, modval As Integer, retval As Integer
    retval = VGA_EngineGetRange(info, index, prop, startval, endval, modval)
    If (retval = 1) Then
        EngineReturnSimpleRange(sender, index, prop, startval, endval, modval)
    End If
    Function = retval
End Function


Sub modmain CDecl Alias "main" ()

    allocateiobitmap(&H3B0, &H30, CPtr(Byte Ptr, &HFFFFFFFF))
    portalloc(&H3B0, &H30)

    allocatepagetable(CPtr(Byte Ptr, &H0), CPtr(Byte Ptr, -1))
    blockallocphys(32, CPtr(Byte Ptr, &HA0000), CPtr(Byte Ptr, &HA0000))

    Dim driver As GFXDRIVER2

    driver.Connectors = 1
    driver.Engines = 4 ' Alphanumeric, 16-color, 256-color, cursor
    driver.setconnectorstate = @VGA_ConnectorSetState
    driver.getconnectorstate = @VGA_ConnectorGetState
    driver.getconnectorrange = @VGA_PatchConnectorGetRange
    driver.setenginestate = @VGA_EngineSetState
    driver.getenginestate = @VGA_EngineGetState
    driver.getenginerange = @VGA_PatchEngineGetRange
    driver.gldispatch = @VGA_GLDispatch

    Dim devid As Integer
    devid = DriverInit
    drv_setname(0,1)
    dim msg(0 to 1) As integer
    msg(0) = 7
    msg(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )

    Write3C2(Read3C2() Or &H3) ' Use 3D4, make sure RAM is enabled
    VGAUnlockCRTC
    
    ' reset the Palette registers
    Dim c as Integer
    For c = 0 To 15
        Write3C0(c, c)
    Next c

    VGASetTextMode()
    VGAEnableDisplay
    outportb(&H3C8, 0)

    VGA_EngineDefaults() ' Load predefined settings

    graphicsmain2(driver, CPtr(Byte Ptr, 0))

End Sub
