' Summary: vga_io.bi
' Contains the function definitions for <vga_io.bas>
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'
' Defines:
'     <Read3C0> <Read3C2> <Read3C4> <Read3CE> <Read3D4>
'     <VGAEnableDisplay> <VGASet320x200Mode> <VGASet320x240Mode>
'     <VGASet400x300Mode> <VGASetModeX> <VGASetTextMode> <VGAUnlockCRTC>
'     <Write3C0> <Write3C2> <Write3C4> <Write3CE> <Write3D4>
'

' VGA register writes
Declare Sub Write3C0 CDecl Alias "Write3C0" (ByVal index as byte, ByVal value as Unsigned byte)
Declare Sub Write3C2 CDecl Alias "Write3C2" (ByVal value as Unsigned byte)
Declare Sub Write3C4 CDecl Alias "Write3C4" (ByVal index as byte, ByVal value as Unsigned byte)
Declare Sub Write3C6 CDecl Alias "Write3C6" (ByVal value as Unsigned byte)
Declare Sub Write3CE CDecl Alias "Write3CE" (ByVal index as byte, ByVal value as Unsigned byte)
Declare Sub Write3D4 CDecl Alias "Write3D4" (ByVal index as byte, ByVal value as Unsigned byte)

' VGA Register Reads
Declare Function Read3C0 CDecl Alias "Read3C0" (ByVal index As Byte) As Unsigned Byte
Declare Function Read3C2 CDecl Alias "Read3C2" () As Unsigned Byte
Declare Function Read3C4 CDecl Alias "Read3C4" (ByVal index As Byte) As Unsigned Byte
Declare Function Read3C6 CDecl Alias "Read3C6" () As Unsigned Byte
Declare Function Read3CE CDecl Alias "Read3CE" (ByVal index As Byte) As Unsigned Byte
Declare Function Read3D4 CDecl Alias "Read3D4" (ByVal index As Byte) As Unsigned Byte

' Mode Setters
Declare Sub VGASet320x200Mode CDecl Alias "VGASet320x200Mode" ()
Declare Sub VGASet320x240Mode CDecl Alias "VGASet320x240Mode" ()
Declare Sub VGASet400x300Mode CDecl Alias "VGASet400x300Mode" ()
Declare Sub VGASet640x480x16Mode Cdecl Alias "VGASet640x480x16Mode" ()
Declare Sub VGASetModeX CDecl Alias "VGASetModeX" ()
Declare Sub VGASetTextMode CDecl Alias "VGASetTextMode" ()

' Helpers
Declare Sub VGAUnlockCRTC CDecl Alias "VGAUnlockCRTC" ()
Declare Sub VGAEnableDisplay CDecl Alias "VGAEnableDisplay" ()
