/* Summary: vga_io.h
 * Contains the function definitions for <vga_io.bas>
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     Public Domain
 *
 * Defines:
 *     <Read3C0> <Read3C2> <Read3C4> <Read3CE> <Read3D4>
 *     <VGAEnableDisplay> <VGASet320x200Mode> <VGASet320x240Mode>
 *     <VGASet400x300Mode> <VGASetModeX> <VGASetTextMode> <VGAUnlockCRTC>
 *     <Write3C0> <Write3C2> <Write3C4> <Write3CE> <Write3D4>
 */
#ifndef __VGA_IO_H__
#define __VGA_IO_H__

// VGA register writes
void Write3C0 (unsigned char index, unsigned char value);
void Write3C2 (unsigned char value);
void Write3C4 (unsigned char index, unsigned char value);
void Write3C6 (unsigned char value);
void Write3CE (unsigned char index, unsigned char value);
void Write3D4 (unsigned char index, unsigned char value);

// VGA Register Reads
unsigned char Read3C0 (unsigned char index);
unsigned char Read3C2 (void);
unsigned char Read3C4 (unsigned char index);
unsigned char Read3C6 (void);
unsigned char Read3CE (unsigned char index);
unsigned char Read3D4 (unsigned char index);

// Mode Setters
/*
Declare Sub VGASet320x200Mode CDecl Alias "VGASet320x200Mode" ()
Declare Sub VGASet320x240Mode CDecl Alias "VGASet320x240Mode" ()
Declare Sub VGASet400x300Mode CDecl Alias "VGASet400x300Mode" ()
Declare Sub VGASet640x480x16Mode Cdecl Alias "VGASet640x480x16Mode" ()
Declare Sub VGASetModeX CDecl Alias "VGASetModeX" ()
Declare Sub VGASetTextMode CDecl Alias "VGASetTextMode" ()
*/
// Helpers
/*
Declare Sub VGAUnlockCRTC CDecl Alias "VGAUnlockCRTC" ()
Declare Sub VGAEnableDisplay CDecl Alias "VGAEnableDisplay" ()
*/
#endif
