' Summary: vgasignal.bi
' Contains the functions for VGA/VESA compatible signal timings
'
' Author:
'     Marcel Sondaar
'
' License
'     <Public Domain>
'

Type VESA_timings
    H_total As Integer
    H_active As Integer
    H_margin As Integer
    H_frontporch As Integer
    H_backporch As Integer
    H_sync As Integer
    V_total As Integer
    V_active As Integer
    V_margin As Integer
    V_frontporch As Integer
    V_backporch As Integer
    V_sync As Integer
    Dotclock As Single
    valid as Byte
    interlace As Byte
End Type

Type VESA_display_properties
    C_prime As Double
    M_prime As Double
    min_retrace_time As Double
    min_porch As Integer
    Cellwidth As Integer
    vsync As Integer
    hsyncpercent As Single
    reducedblank As Byte
End Type

Type VESA_display_basesettings
    M As Single
    C As Single
    K As Single
    J As Single
End Type

Type VESA_mode_properties
    X_resolution As Integer
    Y_resolution As Integer
    Interlace As Byte
    Margins As Single
End Type

Declare Sub LoadDefaultDisplayValues(ByRef vdp As VESA_display_properties)
Declare Function GTF_ComputeFromRefresh(ByVal Refresh As Single, ByRef vmp As VESA_mode_properties, ByRef vdp As VESA_display_properties, ByRef vt As VESA_timings) As Integer
Declare Function GTF_ComputeFromDotclock(ByVal Dotclock As Single, ByRef vmp As VESA_mode_properties, ByRef vdp As VESA_display_properties, ByRef vt As VESA_timings) As Integer
Declare Function GTF_ComputeFromHfreq(ByVal H_Freq As Single, ByRef vmp As VESA_mode_properties, ByRef vdp As VESA_display_properties, ByRef vt As VESA_timings) As Integer

Declare Function GTF_Common_Precalc(ByRef vmp As VESA_mode_properties, ByRef vdp As VESA_display_properties, ByRef vt As VESA_timings) As Integer
Declare Function GTF_Common_Postcalc(ByRef vmp As VESA_mode_properties, ByRef vdp As VESA_display_properties, ByRef vt As VESA_timings) As Integer
