/* Summary: triflat.c
 * Flat shaded triangle rendering on a Voodoo 1
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <swgl/glpipe.h>
#include <swgl/glbuffer.h>
#include "voodoogl.h"
#include "../voodoo.h"

void _gl_flattriangle32(GLvertex * v1, GLvertex * v2, GLvertex * v3)
{
    int temp;

    int x1 = v1->vx; int y1 = v1->vy;
    int x2 = v2->vx; int y2 = v2->vy;
    int x3 = v3->vx; int y3 = v3->vy;

    /* sort points in order. floating bubble sort
       y1 will become topmost, y3 bottommost, y2 in the middle
       this should fix a lot of code duplication later on*/
    if(y1 > y2)
    {
        temp = x1;
        x1 = x2;
        x2 = temp;
        temp = y1;
        y1 = y2;
        y2 = temp;
    }

    if (y2 > y3)
    {
        temp = x2;
        x2 = x3;
        x3 = temp;
        temp = y2;
        y2 = y3;
        y3 = temp;
    }

    if (y1 > y2)
    {
        temp = x1;
        x1 = x2;
        x2 = temp;
        temp = y1;
        y1 = y2;
        y2 = temp;
    }

    int area = (x1 - x2) * (y2 - y3) - (x2 - x3) * (y1 - y2);
    
    // pump the data to the voodoo chip
    
    // todo: FIFO overflow checks
    *((int *)(voodoo_mmio + VOODOO_VERTEX_AX)) = x1;
    *((int *)(voodoo_mmio + VOODOO_VERTEX_AY)) = y1;
    *((int *)(voodoo_mmio + VOODOO_VERTEX_BX)) = x2;
    *((int *)(voodoo_mmio + VOODOO_VERTEX_BY)) = y2;
    *((int *)(voodoo_mmio + VOODOO_VERTEX_CX)) = x3;
    *((int *)(voodoo_mmio + VOODOO_VERTEX_CY)) = y3;
    
    *((int *)(voodoo_mmio + VOODOO_STARTR)) = (int)(v1->cr) << 12;
    *((int *)(voodoo_mmio + VOODOO_STARTG)) = (int)(v1->cg) << 12;
    *((int *)(voodoo_mmio + VOODOO_STARTB)) = (int)(v1->cb) << 12;
    *((int *)(voodoo_mmio + VOODOO_STARTA)) = (int)(v1->ca) << 12;
    
    *((int *)(voodoo_mmio + VOODOO_DRDX)) = 0;
    *((int *)(voodoo_mmio + VOODOO_DGDX)) = 0;
    *((int *)(voodoo_mmio + VOODOO_DBDX)) = 0;
    *((int *)(voodoo_mmio + VOODOO_DADX)) = 0;
    *((int *)(voodoo_mmio + VOODOO_DRDY)) = 0;
    *((int *)(voodoo_mmio + VOODOO_DGDY)) = 0;
    *((int *)(voodoo_mmio + VOODOO_DBDY)) = 0;
    *((int *)(voodoo_mmio + VOODOO_DADY)) = 0;
    
    *((int *)(voodoo_mmio + VOODOO_TRIANGLE_CMD)) = area;
}
