/* Summary: trigoraud.c
 * Goraud shaded triangle rendering
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include <swgl/glpipe.h>
#include <swgl/glbuffer.h>
#include "../voodoo.h"
#include "voodoogl.h"

void _gl_goraudtriangle32(GLvertex * v1, GLvertex * v2, GLvertex * v3)
{
    /*int color = ((int) v3->cb) |
                ((int) v3->cg) << 8 |
                ((int) v3->cr) << 16 |
                ((int) v3->ca) << 24;*/

    GLvertex *o1, *o2, *o3, *tempv;

    /* sort points in order. floating bubble sort
     ' y1 will become topmost, y3 bottommost, y2 in the middle
     ' this should fix a lot of code duplication later on*/
    o1 = v1;
    o2 = v2;
    o3 = v3;
    if (o1->vy > o2->vy)
    {
        tempv = o1;
        o1 = o2;
        o2 = tempv;
    }
    if (o2->vy > o3->vy)
    {
        tempv = o2;
        o2 = o3;
        o3 = tempv;
    }
    if (o1->vy > o2->vy)
    {
        tempv = o1;
        o1 = o2;
        o2 = tempv;
    }

    int x1 = o1->vx; int y1 = o1->vy;
    int x2 = o2->vx; int y2 = o2->vy;
    int x3 = o3->vx; int y3 = o3->vy;

    int r1, g1, b1, r2, g2, b2, r3, g3, b3, a1, a2, a3;

    r1 = o1->cr; g1 = o1->cg; b1 = o1->cb; a1 = o1->ca;
    r2 = o2->cr; g2 = o2->cg; b2 = o2->cb; a2 = o2->ca;
    r3 = o3->cr; g3 = o3->cg; b3 = o3->cb; a3 = o3->ca;

    *((int *)(voodoo_mmio + VOODOO_VERTEX_AX)) = x1;
    *((int *)(voodoo_mmio + VOODOO_VERTEX_AY)) = y1;
    *((int *)(voodoo_mmio + VOODOO_VERTEX_BX)) = x2;
    *((int *)(voodoo_mmio + VOODOO_VERTEX_BY)) = y2;
    *((int *)(voodoo_mmio + VOODOO_VERTEX_CX)) = x3;
    *((int *)(voodoo_mmio + VOODOO_VERTEX_CY)) = y3;
    
    *((int *)(voodoo_mmio + VOODOO_STARTR)) = (int)(v1->cr) << 12;
    *((int *)(voodoo_mmio + VOODOO_STARTG)) = (int)(v1->cg) << 12;
    *((int *)(voodoo_mmio + VOODOO_STARTB)) = (int)(v1->cb) << 12;
    *((int *)(voodoo_mmio + VOODOO_STARTA)) = (int)(v1->ca) << 12;
    
    int area = (x1 - x2) * (y2 - y3) - (x2 - x3) * (y1 - y2);
    
    // solve:
    //
    // (x2-x1)dxr + (y2-y1)dyr = r2-r1
    // (x3-x1)dxr + (y3-y1)dyr = r3-r1
    // dxr = ?, dyr = ?
    //
    // dxr = (r2-r1) - (y2-y1)dyr/(x2-x1)
    // (x3-x1)(r2-r1) - (x3-x1)(y2-y1)dyr/(x2-x1) + (y3-y1)dyr = r3-r1
    // (x3-x1)(r2-r1) - (x3-x1)(y2-y1)dyr/(x2-x1) + (y3-y1)dyr - r3-r1 = 0 
    // (x3-x1)(r2-r1) - r3-r1 = (x3-x1)(y2-y1)dyr/(x2-x1) - (y3-y1)dyr
    // (x2-x1)(x3-x1)(r2-r1) - (x2-x1)(r3-r1) = ((x3-x1)(y2-y1) - (x2-x1)(y3-y1))dyr
    // (x2-x1)(x3-x1)(r2-r1) - (x2-x1)(r3-r1) = 2 * area * dyr
    
    int n1 = (x2-x1) * (x3-x1);
    int n2 = (x2-x1);
    int n3 = (y2-y1) * (y3-y1);
    int n4 = (y2-y1);
    
    int drdy = ((n1 * (r2-r1) - n2 * (r3-r1)) << 12) / area;
    int drdx = ((n3 * (r2-r1) - n4 * (r3-r1)) << 12) / area;
    int dgdy = ((n1 * (g2-g1) - n2 * (g3-g1)) << 12) / area;
    int dgdx = ((n3 * (g2-g1) - n4 * (g3-g1)) << 12) / area;
    int dbdy = ((n1 * (b2-b1) - n2 * (b3-b1)) << 12) / area;
    int dbdx = ((n3 * (b2-b1) - n4 * (b3-b1)) << 12) / area;
    int dady = ((n1 * (a2-a1) - n2 * (a3-a1)) << 12) / area;
    int dadx = ((n3 * (a2-a1) - n4 * (a3-a1)) << 12) / area;
    
    *((int *)(voodoo_mmio + VOODOO_DRDX)) = drdx;
    *((int *)(voodoo_mmio + VOODOO_DGDX)) = dgdx;
    *((int *)(voodoo_mmio + VOODOO_DBDX)) = dbdx;
    *((int *)(voodoo_mmio + VOODOO_DADX)) = dadx;
    *((int *)(voodoo_mmio + VOODOO_DRDY)) = drdy;
    *((int *)(voodoo_mmio + VOODOO_DGDY)) = dgdy;
    *((int *)(voodoo_mmio + VOODOO_DBDY)) = dbdy;
    *((int *)(voodoo_mmio + VOODOO_DADY)) = dady;
    
    *((int *)(voodoo_mmio + VOODOO_TRIANGLE_CMD)) = area;
}
