/** Summary: voodoo.h
 * Contains the register definitions for the 3DFX Voodoo 1 (and 2) cards
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */
 
#ifndef _VOODOO_H_
#define _VOODOO_H_

#define VOODOO_STATUS 0x000
    
#define VOODOO_VERTEX_AX 0x008
#define VOODOO_VERTEX_AY 0x00C
#define VOODOO_VERTEX_BX 0x010
#define VOODOO_VERTEX_BY 0x014
#define VOODOO_VERTEX_CX 0x018
#define VOODOO_VERTEX_CY 0x01C
    
#define VOODOO_STARTR 0x020
#define VOODOO_STARTG 0x024
#define VOODOO_STARTB 0x028
#define VOODOO_STARTZ 0x02C
#define VOODOO_STARTA 0x030
#define VOODOO_STARTS 0x034
#define VOODOO_STARTT 0x038
#define VOODOO_STARTW 0x03C
    
#define VOODOO_DRDX 0x040
#define VOODOO_DGDX 0x044
#define VOODOO_DBDX 0x048
#define VOODOO_DZDX 0x04C
#define VOODOO_DADX 0x050
#define VOODOO_DSDX 0x054
#define VOODOO_DTDX 0x058
#define VOODOO_DWDX 0x05C
    
#define VOODOO_DRDY 0x060
#define VOODOO_DGDY 0x064
#define VOODOO_DBDY 0x068
#define VOODOO_DZDY 0x06C
#define VOODOO_DADY 0x070
#define VOODOO_DSDY 0x074
#define VOODOO_DTDY 0x078
#define VOODOO_DWDY 0x07C
    
#define VOODOO_TRIANGLE_CMD 0x080
    
#define VOODOO_FVERTEX_AX 0x088
#define VOODOO_FVERTEX_AY 0x08C
#define VOODOO_FVERTEX_BX 0x090
#define VOODOO_FVERTEX_BY 0x094
#define VOODOO_FVERTEX_CX 0x098
#define VOODOO_FVERTEX_CY 0x09C
    
#define VOODOO_FSTARTR 0x0A0
#define VOODOO_FSTARTG 0x0A4
#define VOODOO_FSTARTB 0x0A8
#define VOODOO_FSTARTZ 0x0AC
#define VOODOO_FSTARTA 0x0B0
#define VOODOO_FSTARTS 0x0B4
#define VOODOO_FSTARTT 0x0B8
#define VOODOO_FSTARTW 0x0BC

#define VOODOO_FDRDX 0x0C0
#define VOODOO_FDGDX 0x0C4
#define VOODOO_FDBDX 0x0C8
#define VOODOO_FDZDX 0x0CC
#define VOODOO_FDADX 0x0D0
#define VOODOO_FDSDX 0x0D4
#define VOODOO_FDTDX 0x0D8
#define VOODOO_FDWDX 0x0DC
    
#define VOODOO_FDRDY 0x0E0
#define VOODOO_FDGDY 0x0E4
#define VOODOO_FDBDY 0x0E8
#define VOODOO_FDZDY 0x0EC
#define VOODOO_FDADY 0x0F0
#define VOODOO_FDSDY 0x0F4
#define VOODOO_FDTDY 0x0F8
#define VOODOO_FDWDY 0x0FC
    
#define VOODOO_FTRIANGLE_CMD 0x100

#endif
