' Summary: wrapper2.bas
' Contains a common code wrapper for UDI-interface graphics drivers
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>

#include "mos/drivercom.bi"
#include "mos/driver.bi"
#include "mos/gfx.bi"
#include "mos.bi"

Sub graphicsmain2(d As GFXDRIVER2, info As Byte Ptr)

    drv_setname(0, 1)

    Dim msgsize As Integer
    Dim msg() As Integer

    While 1 = 1
        msgsize = drv_PeekMessage()
        If msgsize = 0 Then
            Yield
        Else
            Dim src As Integer
            ReDim msg(msgsize \ 4 + 1)
            src = drv_readmessage(CPtr(Byte Ptr, @(msg(0)) )  )

            Select Case msg(0)
                Case SYSCOMMAND_QUERYINTERFACES
                    Redim msg(2)
                    msg(0) = SYSCOMMAND_QUERYINTERFACES
                    msg(1) = INTERFACE_GRAPHICS2
                    drv_sendmessage(src, 8, CPtr(Byte Ptr, @(msg(0))))

                Case GFXCOMMAND_BIND
                    Redim preserve msg(4)
                    msg(0) = GFXCOMMAND_BIND
                    msg(2) = d.Connectors
                    msg(3) = d.Engines
                    msg(4) = 0
                    drv_sendmessage(src, 20, CPtr(Byte Ptr, @(msg(0))))

                Case GFXCOMMAND_SETCONNECTOR
                    If msgsize = 20 Then
                        d.setconnectorstate(info, msg(2), msg(3), msg(4))
                    Else
                        ' Todo: Error handling
                    End If
                    drv_sendmessage(src, 16, CPtr(Byte Ptr, @(msg(0))))
                Case GFXCOMMAND_SETENGINE
                    If msgsize = 20 Then
                        d.setenginestate(info, msg(2), msg(3), msg(4))
                    Else
                        ' Todo: Error handling
                    End If
                    drv_sendmessage(src, 16, CPtr(Byte Ptr, @(msg(0))))
                Case GFXCOMMAND_GETCONNECTOR
                    If msgsize = 16 Then
                        Redim Preserve msg(5)                        
                        msg(4) = d.getconnectorstate(info, msg(2), msg(3))
                        drv_sendmessage(src, 20, CPtr(Byte Ptr, @(msg(0))))
                    Else
                        ' Todo: Error handling
                    End If
                Case GFXCOMMAND_GETENGINE
                    If msgsize = 16 Then
                        Redim Preserve msg(5)
                        msg(4) = d.getenginestate(info, msg(2), msg(3))                        
                        drv_sendmessage(src, 20, CPtr(Byte Ptr, @(msg(0))))
                    Else
                        ' Todo: Error handling
                    End If


                Case GFXCOMMAND_RANGEENGINE, GFXCOMMAND_RANGECONNECTOR
                    Dim didsend As Integer
                    didsend = 0

                    If msgsize = 16 Then
                        If msg(1) = 0 Then
                            didsend = d.getconnectorrange(info, src, msg(2), msg(3))
                        ElseIf msg(1) = 1 Then
                            didsend = d.getenginerange(info, src, msg(2), msg(3))
                        End If
                    End If

                    If didsend = 0 Then
                        Redim Preserve msg(8)
                        msg(4) = 4
                        msg(5) = 0
                        msg(6) = 0
                        msg(7) = 0
                        drv_sendmessage(src, 32, CPtr(Byte Ptr, @(msg(0))))
                    End If

                Case GFXCOMMAND_GLMESSAGE
                    If d.gldispatch Then
                        d.gldispatch(info, CPtr(Byte Ptr, @(msg(3))), msgsize - 12)
                    End If

            End Select
        End If
    Wend


End Sub

