' Summary: gfx_blob.bas
' renders a spinning cube to a blobs window
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain


Dim Shared BlobsHandler As Sub()
Dim Shared BlobsGate As Long

'$include once: 'mos.bi'
'$include once: 'mos/blobs.bi'

Declare Sub ModMain CDecl alias "main" ()
Declare Sub PutPixel(ByVal x As Long, ByVal y As Long, ByVal color As Long)
Declare Sub Triangle(x1 As Long, y1 As Long, x2 As Long, y2 As Long, x3 As Long, y3 As Long, c as Byte)

' Function: ModMain
' controls the application
'
Sub ModMain CDecl alias "main" ()

    ' find the GUI server
    BlobsGate = 0
    while BlobsGate = 0
        BlobsGate = RouteFind(PORTNAME("UIS0"))
    wend
    Call GateLookup(BlobsGate, @BlobsHandler)

    ' create a window
    Dim rv as Long
    rv = MANGLE(BLOBS_CREATEWINDOW, BlobsGate)
    localipccall(BlobsHandler, rv, 32, 16, 0)
    BlobsGate = rv
    Call GateLookup(BlobsGate, @BlobsHandler)

    ' clear contents
    Dim lpx as long
    Dim lpy as long
    for lpx = 0 to 31
    for lpy = 0 to 31
        PutPixel lpx, lpy, 0
    next lpy
    next lpx


    ' Render stuff

    ' 1   15  29
    '   --*--     1
    ' *<     =>*  8
    ' | --*--  |  15
    ' |   |    |
    ' *-  |  --*  22
    '   --*--     29


    Dim tickcount as Long
    Dim rotate As Single
    Dim period As Single
    Dim cosfx As Single
    Dim sinfx As Single
    Dim cosfy As Single
    Dim sinfy As Single

    tickcount = GetTimerTicks
    period = 1
    rotate = 0

    ' render loop
    while 1=1
        If GetTimerTicks > tickcount then
            tickcount = GetTimerTicks + 1
            period = period + 0.1
            if period > (3.14 / 4) * 3 then
                period = period - (3.14 / 2)
                rotate = 1 - rotate
            end if

            ' compute components
            cosfx = cos(period) * 14
            cosfy = cos(period) * 7
            sinfx = sin(period) * 14
            sinfy = sin(period) * 7

            ' clear screen
            for lpx = 0 to 31
                for lpy = 0 to 31
                    PutPixel lpx, lpy, 0
                next lpy
            next lpx

            ' render triangles
            Call Triangle(15 + cosfx, 8 + sinfy,   15 - cosfx, 8 - sinfy,   15 - sinfx, 8 + cosfy,   2)
            Call Triangle(15 + cosfx, 8 + sinfy,   15 - cosfx, 8 - sinfy,   15 + sinfx, 8 - cosfy,   2)

            Call Triangle(15 + cosfx, 8 + sinfy,   15 - sinfx, 22+ cosfy,   15 - sinfx, 8 + cosfy,   3 + rotate)
            Call Triangle(15 + cosfx, 8 + sinfy,   15 + cosfx, 22+ sinfy,   15 - sinfx, 22+ cosfy,   3 + rotate)

            Call Triangle(15 + cosfx, 22 + sinfy,   15 + sinfx, 8- cosfy,   15 + cosfx, 8 + sinfy,   4 - rotate)
            Call Triangle(15 + cosfx, 22 + sinfy,   15 + sinfx, 8- cosfy,   15 + sinfx, 22- cosfy,   4 - rotate)

        End if

    wend

End Sub

' Function: PutPixel
' sets a pixel via the BLOBS interface
'
' in:
'     x - the x coordinate of the pixel
'     y - the y coordinate of the pixel
'     colour - the color of the pixel
'
Sub PutPixel(ByVal x As Long, ByVal y As Long, ByVal colour As Long)
    localipccall(BlobsHandler, MANGLE(BLOBS_SETPIXEL, BlobsGate), x, y, colour)
End Sub

' Function: Triangle
' renders a triangle
'
' in:
'     x1 - the first point's x coordinate
'     y1 - the first point's y coordinate
'     x2 - the second point's x coordinate
'     y2 - the second point's y coordinate
'     x3 - the third point's x coordinate
'     y3 - the third point's y coordinate
'     c - the color of the triangle
'
Sub Triangle(x1 As Long, y1 As Long, x2 As Long, y2 As Long, x3 As Long, y3 As Long, c as Byte)

    Dim minx As long, maxx As Long, mincount As Long, maxcount As Long
    Dim loopx As Long, halfx As Long, loopy As Long

    Dim topy As Long, topyadd As Long, topysub As Long, topystep As Long
    Dim boty As Long, botyadd As Long, botysub As Long, botystep As Long
    Dim topyfrac As Long, botyfrac As Long

    Dim temp as long
    ' sort points in order. floating bubble sort
    ' x1 will become leftmost, x3 rightmost, x2 in the middle
    ' this should fix a lot of code duplication later on
    If x1 > x2 Then
        temp = x1
        x1 = x2
        x2 = temp
        temp = y1
        y1 = y2
        y2 = temp
    End If

    If x2 > x3 Then
        temp = x2
        x2 = x3
        x3 = temp
        temp = y2
        y2 = y3
        y3 = temp
    End If

    If x1 > x2 Then
        temp = x1
        x1 = x2
        x2 = temp
        temp = y1
        y1 = y2
        y2 = temp
    End If

    minx = x1
    maxx = x3
    halfx = x2
    If minx < 0 Then minx = 0
    If maxx > 319 Then maxx = 319
    ' check if the triangle is visible
    If maxx > minx Then

        boty = y1
        botystep = (y3-y1) \ (x3-x1)
        botyadd = (y3-y1) Mod (x3-x1)
        botysub = (x3-x1)
        botyfrac = 0

        'Split the triangle in two
        If halfx > minx Then

            topy = y1
            topystep = (y2-y1) \ (x2-x1)
            topyadd = (y2-y1) Mod (x2-x1)
            topysub = (x2-x1)
            topyfrac = 0

            For loopx = minx to halfx - 1

                If topy <= boty Then
                    For loopy = topy To boty - 1
                        Putpixel(loopx,loopy,c)
                    Next loopy
                Else
                    For loopy = boty To topy - 1
                        Putpixel(loopx,loopy,c)
                    Next loopy
                End If

                topy = topy + topystep
                topyfrac = topyfrac + topyadd
                If topyfrac > topysub Then
                    topyfrac = topyfrac - topysub
                    topy = topy + 1
                End If
                If topyfrac < -topysub Then
                    topyfrac = topyfrac + topysub
                    topy = topy - 1
                End If

                boty = boty + botystep
                botyfrac = botyfrac + botyadd
                If botyfrac > botysub Then
                    botyfrac = botyfrac - botysub
                    boty = boty + 1
                End If
                If botyfrac < -botysub Then
                    botyfrac = botyfrac + botysub
                    boty = boty - 1
                End If

            Next loopx
        End If

        If halfx < maxx Then

            topy = y2
            topystep = (y3-y2) \ (x3-x2)
            topyadd = (y3-y2) Mod (x3-x2)
            topysub = (x3-x2)
            topyfrac = 0

            For loopx = halfx to maxx - 1

                If topy <= boty Then
                    For loopy = topy To boty - 1
                        Putpixel loopx, loopy, c
                    Next loopy
                Else
                    For loopy = boty To topy - 1
                        Putpixel loopx, loopy, c
                    Next loopy
                End If

                topy = topy + topystep
                topyfrac = topyfrac + topyadd
                If topyfrac > topysub Then
                    topyfrac = topyfrac - topysub
                    topy = topy + 1
                End If
                If topyfrac < -topysub Then
                    topyfrac = topyfrac + topysub
                    topy = topy - 1
                End If

                boty = boty + botystep
                botyfrac = botyfrac + botyadd
                If botyfrac > botysub Then
                    botyfrac = botyfrac - botysub
                    boty = boty + 1
                End If
                If botyfrac < -botysub Then
                    botyfrac = botyfrac + botysub
                    boty = boty - 1
                End If

            Next loopx
        End if

    End If
End Sub
