' Summary: gfx_textmode.bas
' Graphics Driver for standard text mode
'
' Since
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

'$include once: 'mos.bi'
'$include once: 'mos/gfx.bi'

' Todo: documentation
' Todo: comments

Dim Shared allocated As Integer
Dim Shared acquired As Integer

Dim Shared cram As Unsigned Byte Ptr

Declare Sub handlerstub()
Declare Sub handler CDecl (ByVal f as Long, ByVal x As Long, ByVal y As Long, ByVal z As Long)
Declare Sub ModMain CDecl Alias "main"()

Sub ModMain CDecl Alias "main"()

    Dim vaddress As Byte Ptr
    Dim vram As Byte Ptr

    vaddress = CPtr(Byte Ptr, &HA0000)
    vram = CPtr(Byte Ptr, &HA0000000)
    cram = CPtr(Byte Ptr, &HA0018000)

    ' claim video memory
    memmap (64 * 1024 * 2) / 4096, vram, vaddress

    acquired = 1
    allocated = 0

    Dim gate As Long
    Dim result As Long
    Dim index As Long

    Dim stub as Sub()
    stub = @handlerstub

    gate = gatealloc(stub)
    index = 0
    result = 1
    while result <> 0
        result = routealloc(gate, PORTNAME("GFX" + Str(index)))
        index = index + 1
    Wend


    While 1 = 1
    Wend

End Sub

Sub handler CDecl (ByVal f As Long, ByVal x As Long, ByVal y As Long, ByVal z As Long)

    Select Case (f \ 65536)
        Case GFX_INFO
            f = 0
            z = 0

        Case GFX_SETPIXEL
            Dim baseaddr As Long
            if y >= 50 then Exit Sub
            if x >= 80 then Exit Sub
            baseaddr = x * 2 + 80 * (y And &HFE)
            cram[baseaddr] = 220
            If (y mod 2) = 1 then
                cram[baseaddr+1] = (cram[baseaddr+1] And &HF0) + (z And &H7)
            Else
                cram[baseaddr+1] = (cram[baseaddr+1] And &H0F) + (z And &H7) * 16
            End If

        Case GFX_SETCHAR
            Dim baseaddr As Long
            if x < 0 then Exit Sub
            if y < 0 then Exit Sub
            if y >= 25 then Exit Sub
            if x >= 80 then Exit Sub
            baseaddr = x * 2 + 160 * y
            cram[baseaddr] = z
            cram[baseaddr + 1] = &Hf

    End Select
End Sub

Sub handlerstub()
    Call ipccdeclconv(@handler)
End Sub