' Summary: keyboard.bas
' Contains a standard AT keyboard driver
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

' includes
'$include once: 'mos.bi'
'$include once: 'x86.bi'
'$include once: 'mos/input.bi'

' function declarations
Declare Sub handlerstub()
Declare Sub handler (ByVal f as Long, ByVal x As Long, ByVal y As Long, ByVal z As Long)
Declare Sub ModMain CDecl Alias "main"()
Declare Sub ReadKeyboard ()

' Variable: buttons
' Stores the up/down values for all of the keys
Dim Shared buttons(0 to 255) As Long

' Variable: keycodes
' Stores the last 64 keyboard events
Dim Shared keycodes(0 to 63) As Long

' Variable: lastkeycounter
' Stores the keypress counter
Dim Shared lastkeycounter As Long

' Variable: LastRead
' Stores the last byte read from the keyboard controller
Dim Shared LastRead As Unsigned Byte

' Function: ModMain
' Contains the driver's startup code
Sub ModMain CDecl Alias "main" ()

    Dim aspace As Long

    Dim stub As Sub()
    Dim index As Long
    Dim result As Long
    
    Dim lp as long

    ' claim KBC
    PortAlloc &H60, 2

    ' load values storage
    for lp = 0 to 255
        buttons(lp) = 0
    next lp
    for lp = 0 to 63
        keycodes(lp) = 0
    next lp
    Lastread = 0


    ' create interface
    stub = @handlerstub
    gate = gatealloc(stub)
    index = 0

    result = 1
    while result <> 0
        result = routealloc(gate, PORTNAME("INP" + Str(index)))
        index = index + 1
    Wend

    ' loop forever
    While 1=1
        ReadKeyboard
    Wend

End Sub

' Function: handler
' handles the incoming calls
'
' in:
'     f      - first (mangled) parameter
'     button - second parameter
'     state  - third parameter
'     x      - fourth parameter
'
' out:
'     f      - first return paramter (success value)
'     button - second return parameter
'     state  - third return parameter
'     x      - fourth return parameter
'
Sub handler (ByVal f As Long, ByVal button As Long, ByVal state As Long, ByVal x As Long)
    Select case (f \ 65536)
        Case INPUTDEVCALLS.INPUT_GETCOUNT
            button = 256

        Case INPUTDEVCALLS.INPUT_GETINFO
            button = INPUTDEVTYPES.INPUT_BUTTON
            
        Case INPUTDEVCALLS.INPUT_GETSTATE
            if button >= 0 and button < 256 then state = buttons(button)

        Case INPUTDEVCALLS.INPUT_GETEVENTCOUNT
            button = lastkeycounter

        Case INPUTDEVCALLS.INPUT_GETEVENT
            ' skip one entry as it might be overwritten.
            if lastkeycounter - button < 63 and lastkeycounter - button > 0 then
                Dim tempbutton as long 
                tempbutton = button
                button = keycodes(button and &H3F)
                state = button \ 65536
                f = state
                button = button and &HFFFF
                ' test the counter again to see if we got a conflicted read.
                if lastkeycounter - tempbutton >= 63 then
                    button = -1
                    f = -1
                end if
            else
                button = -1
                f = -1
            end if
        Case Else
            f = -1
    End Select
End Sub

' Function: handlerstub
' converts the register calling convention into a FB-compatible convention
Sub handlerstub()
    ipccdeclconv(@handler)
End Sub

' Function: ReadKeyboard
' reads a keypress from the kbc and adjusts the state accordingly
'
' a byte is read and acknowledged, and if it equals e0, another byte
' is read and acked. then the msb of the last byte is set it is a release, 
' and if its clear its a press
' the presence of e0 tells us wether it is an extended key or not.
Sub ReadKeyboard()

    Dim key as unsigned byte
    Dim temp as unsigned byte
    Dim escaped as byte

    escaped = 0
    key = 0

    ' wait for a keypress
    While Key = LastRead or key = 0
        key = inportb(&H60)                 ' peek at the byte posted by the kbc
        temp = inportb(&H61)                ' acknowledge byte read
        outportb(&H61,temp Or  &H80)        ' by disabling
        outportb(&H61,temp And &H7F)        ' and reenabling
    Wend

    If key = &HE0 Then
        key = 0
        escaped = 1                         ' it is escaped
        While Key = LastRead or key = 0     ' repeat the sequence
            key = inportb(&H60)
            temp = inportb(&H61)
            outportb(&H61,temp Or  &H80)
            outportb(&H61,temp And &H7F)
        Wend
    End If

    LastRead = Key

    ' compute wether it was a keyup or keydown
    If (key and &H80) = &H80 Then
        temp = 0
    Else
        temp = 1
    End If
    if escaped = 1 then 
        key = key or &H80
    else
        key = key and &H7f
    end if

    ' adjust keypress
    buttons(key) = temp
    keycodes(lastkeycounter Mod 64) = clng(key) + (clng(temp) * &H10000&)
    lastkeycounter = lastkeycounter + 1
End Sub