' Summary: autoload.bas
' Loads drivers into memory based on their presence
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purposes
'

#include "mos.bi"
#include "mos/drivercom.bi"

Dim Shared visited() As Byte
Dim Shared visitedcount As Integer
Dim Shared devloaded As Integer

Declare Function AutoloadPciDevice(vendor As Integer, device As Integer) As Integer
Declare Function AutoloadPciClass(class1 As Byte, class2 As Byte, iftype As Byte) As Integer

Declare Sub LoadDevice(dev As String)
Declare Sub PrintString (s As String, offset as long = 0)

Sub modmain CDecl Alias "main"

    drv_setname(DRIVER_MGR, 1)

    Dim lp As Integer

    visitedcount = 0
    lp = 1
    While 1 = 1
        If lp > visitedcount Then
            visitedcount = lp
            ReDim Preserve visited(lp+1)
        End If

        If visited(lp) = 0 Then
            Dim os(0 to 1) As Integer
            Dim rs As String

            devloaded = 0

            os(0) = 2
            os(1) = lp

            drv_sendmessage(DRIVER_MGR * &H10000, 8, CPtr(Byte Ptr, @(os(0))) )

            While drv_peekmessage() = 0
                Yield
            Wend

            Dim l as Integer
            l = drv_peekmessage()
            rs = space$(l)
            drv_readmessage(*CPtr(Byte Ptr Ptr, @rs))

            If l = 1 Then
                '*CPtr(Byte Ptr, &HB8000 + 2 * lp) = &H45
                lp = 1
            ElseIf l = 22 And left$(rs, 4) = "PCI " Then
                Dim vendor As Integer, devid As Integer
                Dim c1 As Byte, c2 As byte, c3 As Byte

                vendor = ValInt("&H" & Mid$(rs, 5, 4))
                devid = ValInt("&H" & Mid$(rs, 10, 4))
                c1 = ValInt("&H" & Mid$(rs, 15, 2))
                c2 = ValInt("&H" & Mid$(rs, 18, 2))
                c3 = ValInt("&H" & Mid$(rs, 21, 2))

                'printstring hex$(vendor), 32
                'printstring hex$(devid), 48
                'printstring rs, 64

                If AutoloadPciDevice(vendor, devid) = 0 Then
                    AutoloadPciClass(c1, c2, c3)
                End if

                visited(lp) = 1
                '*CPtr(Byte Ptr, &HB8000 + 2 * lp) = &H41
                if devloaded = 1 then
                    '*CPtr(Byte Ptr, &HB8001 + 2 * lp) = &H0A
                end if
                lp = lp + 1
            'ElseIf l > 1 Then
            '    visited(lp) = 1
            '    lp = lp + 1
            Else
                '*CPtr(Byte Ptr, &HB8000 + 2 * lp) = &H58
                lp = lp + 1
            End If
        Else
            lp = lp + 1
        End If
        Yield
    Wend
End Sub


'Sub PrintString (s As String, offset as long = 0)
'    Dim lp As Long
'    Dim ch As Byte
'    Dim vram As Byte Ptr
'    vram = CPtr(Byte Ptr, &HB8000 + offset)
'
'    For lp = 1 To len(s)
'        ch = asc(mid$(s,lp,1))
'        vram[lp * 2 - 2] = ch
'        vram[lp * 2 - 1] = 7
'    Next lp
'End Sub



Sub LoadDevice(dev As String)

    Dim msg As String
    msg = chr$(1) & chr$(0) & chr$(0) & chr$(0) & dev

    drv_sendmessage(DRIVER_MGR * &H10000 + 3, 12, *CPtr(Byte Ptr Ptr, @msg))
    While drv_peekmessage() = 0
        Yield
    Wend

    Dim l as Integer
    l = drv_peekmessage()
    msg = space$(l)
    drv_readmessage(*CPtr(Byte Ptr Ptr, @msg))

    devloaded = 1
End Sub

Function AutoloadPciDevice(vendor As Integer, device As Integer) As Integer
    'While 1 = 1
    'Wend

    Function = 1

    Select Case vendor

        Case &H1234 ' Technology Inc / Bochs
            If device = &H1111 Then LoadDevice("BGA     ")      ' Bochs Graphics Array (PCI)

        Case &H8086 ' Intel
            Function = 0

        Case Else
            Function = 0
            'LoadDevice("        ")

    End Select
End Function

Function AutoloadPciClass(class1 As Byte, class2 As Byte, iftype As Byte) As Integer

    Function = 1

    Select Case class1

        Case &H00   ' legacy PCI
            If class2 = 1 And iftype = 0 Then   ' 00:01:00 are legacy VGAs
                LoadDevice("STDVGA  ")
            Else
                Function = 0
            End If

        'Case &H01   ' Mass Storage device/controller
        'Case &H02   ' NIC
        Case &H03   ' Display Device
            Select Case class2
                Case 0  ' Standards-compliant graphics device
                    If iftype = 0 Then          ' 03:00:00 are VGA-compatibles
                        LoadDevice("STDVGA  ")
                    Else
                        Function = 0
                    End If

                ' Case 1 ' XGA controller
                ' Case 2 ' 3D controller

                Case Else
                    Function = 0
            End Select
        'Case &H04   ' Multimedia Device
        'Case &H05   ' Memory Controller
        'Case &H06   ' Bridge
        'Case &H07   ' Communication ports
        'Case &H08   ' System resources
        'Case &H09   ' Input Device
        'Case &H0A   ' Docking Station
        'Case &H0B   ' Processor
        'Case &H0C   ' Serial Bus controller
        'Case &H0D   ' Wireless NICs
        'Case &H0E   ' Intelligent I/O
        'Case &H0F   ' Sattelite transmitter/receiver/transceivers
        'Case &H10   ' Encryption device
        'Case &H11   ' Data acquisition and signal processing


        Case Else
            Function = 0

    End Select
End Function
