' Summary: bootconf.bas
' Interactive Boot Configurator
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purposes
'

#include "mos.bi"
#include "mos/drivercom.bi"
#include "drivers.bi"
#include "rawvgatk.bi"

Declare Function StartWindow() As Integer
Declare Function RootInterfaceWindow(ByRef needsconfig As Integer) As String
Declare Sub MainWindow()

Declare Function IsBusdriver(ByRef drvname As String) As Integer
Declare Sub ReleaseResources()

Declare Function ReadKey() As Byte
Declare Function ReadKeyboard () As Unsigned Byte
Declare Sub InitKeyboard()

Type DEVCONTROL
    Drivername As String * 15
    Driverindex As Integer
    nextarg As DEVARG Ptr
End Type

Sub modmain CDecl Alias "main" ()

    cram = CPtr(Byte Ptr, &HB8000)
    BlockAllocPhys(8, cram, cram)
    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    InitKeyboard()

    ClearScreen

    Yield

    Dim rv as integer, bootapp As String

    drv_setname(0, &Hb0ef)
    Dim i(0 to 1) As Integer

    rv = 1
    bootapp = RootInterfaceWindow(rv)

    If rv = 1 Then
        rv = StartWindow
        If rv = 0 Then
            ' Todo: start autoload
        Else
            MainWindow
        End If
    Else
        ReleaseResources
    End if

    Dim rs As String
    rs = chr$(1) + chr$(0) + chr$(0) + chr$(0) + UCase$(bootapp)
    while len(rs) < 12
        rs = rs + " "
    wend
    drv_sendmessage(DRIVER_MGR * &H10000 + 3, 12, *CPtr(Byte Ptr Ptr, @rs) )

    Yield

End Sub

Function StartWindow() As Integer
    ClearScreen
    DrawWindow 20, 10, 40, 4, &H1E

    PrintString "Automatic Configuration", 11 * 160 + 29 * 2 , &H1E
    PrintString "Manual Configuration", 12 * 160 + 29 * 2 , &H1E

    Dim rv As Integer, kb As Integer
    rv = 0

    While 1 = 1
        PrintString chr$(16), (11+rv) * 160 + 27 * 2 , &H1C
        Yield
        kb = ReadKeyboard
        Yield
        if kb > 0 then
            PrintString str$(kb), 24 * 160 + 70 * 2 , &H08

            PrintString " ", (11+rv) * 160 + 27 * 2 , &H1E

            'PrintString str$(kb), 20 * 160, &H0F

            If kb = &H48 Or kb = &H50 Or kb = &HC8 Or kb = &HD0 Then
                rv = 1 - rv
            Elseif kb = &H1C Then
                Function = rv
                Exit Function
            End If
        End if

    Wend
    Function = rv

End Function

Function RootInterfaceWindow(ByRef needsconfig As Integer) As String

    ClearScreen

    DrawWindow 20, 6, 40, 14, &H1E
    PrintString "MysticOS Configurator", 7 * 160 + 30 * 2 , &H1F

    PrintString "Select the root application:", 9 * 160 + 27 * 2 , &H1F
    PrintString "Graphics Demo", 10 * 160 + 29 * 2 , &H1E
    PrintString "Filesystem test", 11 * 160 + 29 * 2 , &H1E
    PrintString "VGA Compatibility Tests", 12 * 160 + 29 * 2 , &H1A
    PrintString "x86emu test tool", 13 * 160 + 29 * 2 , &H1A
    PrintString "Voodoo Test", 14 * 160 + 29 * 2 , &H1A
    PrintString "S3 Trio64 Test", 15 * 160 + 29 * 2 , &H1A
    PrintString "ATI Mach64/3D Rage Test", 16 * 160 + 29 * 2 , &H1A
    PrintString "Tweak tool", 17 * 160 + 29 * 2 , &H1A
    PrintString "Prototyping slot", 18 * 160 + 29 * 2 , &H1A

    Dim rv As Integer, kb As Integer
    rv = 0

    Const items = 9



    While kb <> &H1C
        PrintString chr$(16), (10+rv) * 160 + 27 * 2 , &H1C
        Yield
        kb = ReadKeyboard
        Yield
        if kb > 0 then
            PrintString str$(kb), 24 * 160 + 70 * 2 , &H08

            PrintString " ", (10+rv) * 160 + 27 * 2 , &H1E

            'PrintString str$(kb), 20 * 160, &H0F

            If kb = &H48 Or kb = &HC8 Then
                rv = rv - 1
                if rv = -1 then rv = rv + items
            ElseIf kb = &H50 or kb = &HD0 Then
                rv = rv + 1
                if rv = items then rv = 0
            End If
        End if

    Wend

    If rv <= 1 Then
        needsconfig = 1
    Else
        needsconfig = 0
    End If

    Function = ""

    Select Case rv

        Case 0
            Function = "WORDS   "	    
        Case 1
            Function = "FSTEST  "
        Case 2
            Function = "VGACHECK"
        Case 3
            Function = "VESAEMU "
        Case 4
            Function = "T3DFXV1 "
        Case 5
            Function = "T64VTEST"
        Case 6
            Function = "MACH64_T"
        Case 7
            Function = "TWEAK   "
        Case 8
            Function = "HACKME  "

        Case else
            Function = ""
    End Select

End Function

Sub MainWindow()
    Dim nodenumber As Integer
    nodenumber = 0

    Dim nos() As Integer
    Dim tags() As String
    Dim devargs() As DEVCONTROL
    Dim shaded() As Integer

    Dim devassign As Integer

    Dim lp As Integer

    Dim i(0 to 1) as Integer
    Dim o As String
    Dim done As Integer

    While done = 0 ' reconfigure loop

        done = 0
        nodenumber = nodenumber + 1 ' change to 1-based

        While done = 0
            i(0) = 2
            i(1) = nodenumber
            drv_sendmessage(DRIVER_MGR * &H10000, 8, CPtr(Byte Ptr, @(i(0))) )
            Yield

            Dim isize As Integer
            Dim rs As String

            isize = 0
            While isize = 0
                isize = drv_peekmessage()
                If isize = 0 then Yield
            Wend
            rs = space$(isize)
            Dim myptr As Byte Ptr
            myptr = *CPtr(Byte Ptr Ptr, @rs)
            drv_readmessage(myptr)

            If isize <= 1 then
                done = 1
                nodenumber = nodenumber - 1
            Else
                Redim preserve nos(nodenumber)
                ReDim preserve tags(nodenumber)
                ReDim preserve shaded(nodenumber)
                nos(nodenumber-1) = nodenumber
                tags(nodenumber-1) = rs
                shaded(nodenumber-1) = 0
                nodenumber = nodenumber + 1
            End if

            PrintString rs, 20 * 160, &H0F

        Wend

        ClearScreen

        Dim listoffset As Integer
        Dim curnumber As Integer
        listoffset = 0
        curnumber = 0

        Redim Preserve devargs(nodenumber)
        For lp = 0 to nodenumber-1
            devargs(lp).Driverindex = SelectDriver(tags(lp))
            devargs(lp).Drivername = GetDriverName(devargs(lp).Driverindex)
            if devargs(lp).Driverindex < -1 Then devargs(lp).Driverindex = -1
    
            devargs(lp).nextarg = CPtr(DEVARG Ptr, 0)
        Next lp
    
        Dim ipos As Integer
        done = 0
    
        While done = 0

            DrawWindow 2, 2, 40, 20, &H1E

            Dim lp As Integer
            lp = 0
            If listoffset <> 0 Then
                PrintString chr$(30), (3) * 160 + 16*2, &H1D
                lp = 1
            End If
            While lp < 18 And lp + listoffset < nodenumber
                PrintString devargs(lp + listoffset).Drivername, (3+lp) * 160 + 30*2, IIf(shaded(lp+listoffset) = 1, &H17, &H1E)

                PrintString tags(lp + listoffset), (3+lp) * 160 + 5*2, &H1E
                lp = lp + 1
            Wend

            If lp < 18 Then
                PrintString "Load bus drivers", (3+lp) * 160 + 6*2, &H1F
                lp = lp + 1
            End If
            If (lp + listoffset) <= nodenumber Then
                PrintString chr$(31), (3+lp) * 160 + 16*2, &H1D
            Else
                PrintString "Continue", (3+lp) * 160 + 6*2, &H1F
            End if


            PrintString Chr$(16), (3+ipos-listoffset) * 160 + 3 * 2, &H1D

            While ipos >= iif(listoffset > 0, listoffset + 1, 0) And ipos < listoffset + 18 And done = 0
                Dim keyindex As Integer
                Yield
                keyindex = ReadKeyboard
                Select Case keyindex
                    Case &H1C, &H4D, &HCD
                        If ipos < nodenumber Then
                            If shaded(ipos) = 0 Then
                                Dim curentry As Integer
                                curentry = ipos

                                PrintString Chr$(32), (3+ipos - listoffset) * 160 + 3 * 2, &H1D

                                PrintString Chr$(17), (3+ipos - listoffset) * 160 + 29 * 2, &H1D
                                PrintString Chr$(16), (3+ipos - listoffset) * 160 + 40 * 2, &H1D

                                keyindex = 0
                                While keyindex <> &H1C and keyindex <> 1
                                    Yield
                                    keyindex = readkeyboard

                                    Dim update As Byte
                                    update = 0

                                    Select Case keyindex
                                        Case &H4D, &HCD
                                            update = 1
                                            devargs(curentry).driverindex = devargs(curentry).driverindex + 1
                                            if devargs(curentry).driverindex = devicecount then devargs(curentry).driverindex = -1

                                        Case &H4B, &HCB
                                            update = 1
                                            devargs(curentry).driverindex = devargs(curentry).driverindex - 1
                                            if devargs(curentry).driverindex = -2 then devargs(curentry).driverindex = devicecount - 1

                                        Case &H50, &HD0
                                            update = 1
                                            devargs(curentry).driverindex = SelectDriverPrime(tags(curentry), devargs(curentry).driverindex + 1)
                                            if devargs(curentry).driverindex < 0 Then devargs(curentry).driverindex = -1

                                        Case &H48, &HC8

                                        Case else
    
                                    End Select
    
                                    If update = 1 Then
                                        devargs(curentry).Drivername = GetDriverName(devargs(curentry).Driverindex)
    
                                        PrintString "         ", (3+ipos-listoffset) * 160 + 30*2, &H1E
                                        If QueryDriverSupport(tags(curentry), devargs(curentry).driverindex) < 0 And devargs(curentry).driverindex >= 0 Then
                                            PrintString devargs(curentry).Drivername, (3+ipos - listoffset) * 160 + 30*2, &H1C
                                        Else
                                            PrintString devargs(curentry).Drivername, (3+ipos - listoffset) * 160 + 30*2, &H1E
                                        End If
                                    End If
    
                                Wend
    
                                PrintString Chr$(32), (3+ipos - listoffset) * 160 + 29 * 2, &H1D
                                PrintString Chr$(32), (3+ipos - listoffset) * 160 + 40 * 2, &H1D
    
                                PrintString Chr$(16), (3+ipos - listoffset) * 160 + 3 * 2, &H1D
                            End If
                        Elseif ipos = nodenumber Then
                            PrintString Chr$(32), (3+ipos - listoffset) * 160 + 3 * 2, &H1D
                            done = 2
                        Elseif ipos = nodenumber + 1 Then
                            PrintString Chr$(32), (3+ipos - listoffset) * 160 + 3 * 2, &H1D
                            done = 1
                        End If

                    Case &H48, &HC8
                        PrintString Chr$(32), (3+ipos - listoffset) * 160 + 3 * 2, &H1D
                        If ipos = 0 then
                            ipos = nodenumber + 1
                        Else
                            ipos = ipos - 1
                        End If
                        If ipos >= listoffset And ipos < listoffset + 19 Then
                            PrintString Chr$(16), (3+ipos - listoffset) * 160 + 3 * 2, &H1D
                        End If

                    Case &H50, &HD0
                        PrintString Chr$(32), (3+ipos - listoffset) * 160 + 3 * 2, &H1D
                        if ipos = nodenumber + 1 then
                            ipos = 0
                        else
                            ipos = ipos + 1
                        end if

                        If ipos >= listoffset And ipos < listoffset + 19 Then
                            PrintString Chr$(16), (3+ipos - listoffset) * 160 + 3 * 2, &H1D
                        End If

                    Case 0
                    Case Else
                        PrintString Hex$(keyindex) & "  ", 24 * 160 + 120, &H07
                End Select
            Wend
    
            If (ipos <= listoffset) and (listoffset > 0) Then
                listoffset = ipos - 1
                If listoffset < 0 Then listoffset = 0
            End If
            If ipos = 0 Then
                listoffset = 0
            End If
            If (ipos >= listoffset + 18) Then
                listoffset = ipos - 17
            End If

        Wend

        If done = 1 Then ReleaseResources

        For ipos = 0 To nodenumber - 1
            If devargs(ipos).driverindex >= 0 then
                ' start drivers
                If (done = 1 Or IsBusdriver(devargs(ipos).drivername)) And shaded(ipos) = 0 Then
                    shaded(ipos) = 1
                    Dim msg As String
                    msg = chr$(1) + chr$(0) + chr$(0) + chr$(0) + UCase$(devargs(ipos).drivername)


                    for lp = 5 to 12
                        if mid$(msg, lp, 1) = chr$(0) then msg = left$(msg, lp-1) + " " + mid$(msg, lp+1)
                    next lp

                    msg = msg + " -n " + str$(ipos + 1) ' from 0-based list to 1-based device entries

                    drv_sendmessage(DRIVER_MGR * &H10000 + 3, 4 + len(msg), *CPtr(Byte Ptr Ptr, @msg) )
                    Yield
                End If
            End If
        Next ipos

        ' loop around the entire detect sequence for load/continue
        If done = 2 Then 
            done = 0
            For ipos = 0 to 3
                Yield ' allow time-independent device registration messages to propagate
            Next ipos
        End If
    Wend


End Sub

Sub ReleaseResources
    BlockDealloc(CPtr(Byte Ptr, &HB8000), CPtr(Byte Ptr, &HBFFFF))
End Sub

Function IsBusdriver(ByRef drvname As String) As Integer
    If drvname = "atactl" Then          ' registers ATA-x and ATAPI-x devices
        Function = 1
    ElseIf drvname = "atadisk" Then     ' indirectly registers via fsprobe
        Function = 1
    ElseIf drvname = "imch" Then        ' enables hidden PCI devices
        Function = 1
    ElseIf drvname = "u_cmos" Then 
        Function = 1
    ElseIf drvname = "dospart" Then 
        Function = 1
    Else
        Function = 0
    End If
End Function

