'
' Summary: clistener.bas
' *Implements the class wrapping the IPC*
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "mos/channel.bi"
#include "mos/event.bi"

Constructor MCChannelListener
    
End Constructor

Destructor MCChannelListener

End Destructor

Sub MCChannelListener.SetHandler(ByVal index As Integer, ByVal handler As Function CDecl(ByVal thisptr As MCChannelListener Ptr, ByVal sender As Integer, ByVal length As Integer, ByVal contents As Byte Ptr) As Integer)
    Dim subtree As Integer, subindex As Integer
    'Asm
    '    XCHG BX, BX
    'End Asm
    subtree = index SHR 16
    subindex = index AND &H0000FFFF&
    If (subtree >= mos_eventhandles->max_roots) Then Exit Sub
    
    Dim tree_entry As MOS_EVENTHANDLER_TREE Ptr
    tree_entry = (mos_eventhandles->sys_trees) + subtree
    
    If tree_entry->max_message_sub <= subindex Then
        Dim handlearray As MOS_EVENTHANDLER Ptr
        handlearray = Allocate((subindex + 1) * Len(MOS_EVENTHANDLER))
        
        ' TODO: copy existing handles
        Dim lp As Integer
        For lp = 0 To tree_entry->max_message_sub - 1
            handlearray[lp] = tree_entry->handles[lp]
        Next lp
        
        tree_entry->max_message_sub = subindex + 1
        If (tree_entry->handles <> CPtr(MOS_EVENTHANDLER Ptr, 0)) Then
            Deallocate (tree_entry->handles)
	End If
        tree_entry->handles = handlearray
    End If
   
    tree_entry->handles[subindex].callback = handler
    tree_entry->handles[subindex].customdata = CPtr(Byte Ptr, CPtr(Any Ptr, @This))
    
End Sub

Function MCChannelListener.GetHandlerPointer() As MOS_EVENTHANDLER Ptr
    Function = CPtr(MOS_EVENTHANDLER Ptr, 0)
End Function
    
Function MCChannelListener.Start() As Integer
    Function = mos_eventloop()
End Function
