' Summary: devmgr.bas
' Device Manger Server
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purporses
'

#include "mos.bi"
#include "mos/drivercom.bi"
#include "mos/devmgr.bi"

Type DevNode
    Declare Constructor(ByVal nodenumber As Integer)

    DevIndex As Integer
    DevAddress As Integer
    DrvAddress As Integer

    TypeID As Byte Ptr
    TypeIDsize As Integer

    LocID As Byte Ptr
    LocIDsize As Integer

    Nodes as Integer Ptr
    Nodecount As Integer

    IsTransparent As Byte
End Type

Dim Shared Devices() As DevNode Ptr
Dim Shared Devcount As Long

Declare Sub handlemessage(ByVal size As Integer)

Constructor DevNode (ByVal nodenumber As Integer)
    this.DevIndex = nodenumber
    this.DrvAddress = 0
    this.DevAddress = 0
    this.TypeIDSize = 0
    this.LocIDSize = 0
    this.isTransparent = 0
    this.Nodecount = 0
End Constructor

Sub modmain CDecl Alias "main" ()

    redim Devices(1)
    Devices(0) = new DevNode(0)
    devcount = 1

    Dim size as Integer

    drv_setname(DRIVER_MGR, 0)
    While 1 = 1
        size = drv_peekmessage()
        if (size > 0) then
           handlemessage(size)
        else
           Yield
        end if
    Wend
End Sub

Sub handlemessage(ByVal size as integer)
    Dim msgdata() As Integer
    redim msgdata(size \ 4 + 1)

    Dim src As Integer
    src = drv_readmessage(  CPtr(Byte Ptr, @(msgdata(0)) )  )

    'if (src = &HBEEF) then *cptr(byte ptr, &Hbeef1) = 0

    If (size < 8) Then Exit Sub

    Select Case msgdata(0)
        Case 0

        Case DEVMGRCOMMANDS_CONNECTIVITY ' Browse node connectivity
            Dim nodenumber as Integer
            Dim nodecount As Integer
            nodenumber = msgdata(1)
            nodecount = 0
            If nodenumber >= Devcount Then
                nodecount = 0
            ElseIf CInt(Devices(nodenumber)) = 0 Then
                nodecount = 0
            Else
                nodecount = Devices(nodenumber)->Nodecount
                ReDim msgdata(nodecount + 1)
            End If

            Dim lp As Integer
            For lp = 0 to Devices(nodenumber)->Nodecount - 1
                msgdata(lp+1) = Devices(nodenumber)->Nodes[lp]
            Next lp

            msgdata(0) = nodecount
            drv_sendmessage(src, (nodecount + 1) * 4, CPtr(Byte Ptr, @(msgdata(0)) )  )

        Case DEVMGRCOMMANDS_GETNAME ' Get node identifier
            Dim ident as Byte Ptr
            Dim isize as Integer
            if msgdata(1) >= Devcount Then
                isize = 1
                ident = CPtr(Byte Ptr, @isize) + 1
            ElseIf CInt(Devices(msgdata(1))) = 0 Then
                isize = 1
                ident = CPtr(Byte Ptr, @isize) + 1
            Else
                isize = Devices(msgdata(1))->TypeIDsize
                ident = Devices(msgdata(1))->TypeID
                if isize = 0 then
                    isize = 1
                    ident = CPtr(Byte Ptr, @isize) + 1
                end if
            End If
            drv_sendmessage(src, isize, ident)


        Case DEVMGRCOMMANDS_ADD ' Add node
            Dim lp As Integer
            lp = Devcount

            Devcount = Devcount + 1
            ReDim Preserve Devices(Devcount + 1)
            Devices(lp) = new DevNode(lp)

            Devices(lp)->Nodes = new Integer[1]
            Devices(lp)->Nodes[0] = msgdata(1)
            Devices(lp)->Nodecount = 1

            ' Redimension nodes array
            Dim lp2 As Integer
            Dim na As Integer Ptr
            na = new Integer[Devices(msgdata(1))->Nodecount + 1]
            For lp2 = 0 To Devices(msgdata(1))->Nodecount - 1
                na[lp2] = Devices(msgdata(1))->Nodes[lp2]
            Next lp2
            na[Devices(msgdata(1))->Nodecount] = lp
            Devices(msgdata(1))->Nodecount = Devices(msgdata(1))->Nodecount + 1
            Delete Devices(msgdata(1))->Nodes
            Devices(msgdata(1))->Nodes = na

            msgdata(0) = lp
            drv_sendmessage(src, 4, CPtr(Byte Ptr, @(msgdata(0)) )  )

        Case DEVMGRCOMMANDS_SETNAME ' Set node info
            if msgdata(1) >= Devcount Then
            ElseIf CInt(Devices(msgdata(1))) = 0 Then
            Else
                Delete Devices(msgdata(1))->TypeId
                Devices(msgdata(1))->TypeId = new Byte[size-8]
                Devices(msgdata(1))->TypeIDsize = size - 8
                Dim lp As Integer
                Dim srcp As Byte Ptr
                srcp = CPtr(Byte Ptr, @(msgdata(2)) )
                For lp = 0 to size - 9
                    Devices(msgdata(1))->TypeId[lp] = srcp[lp]
                    '*Cptr(Byte Ptr, &HB8000 + 2 * lp) = srcp[lp]
                Next lp
            End If

        Case DEVMGRCOMMANDS_SETADDR ' Set driver address
            if msgdata(1) >= Devcount Then
            ElseIf CInt(Devices(msgdata(1))) = 0 Then
            Else
                Devices(msgdata(1))->DrvAddress = src
            End If

        Case DEVMGRCOMMANDS_GETADDR ' Get Driver Address
            if msgdata(1) >= Devcount Then
            ElseIf CInt(Devices(msgdata(1))) = 0 Then
            Else
                msgdata(0) = Devices(msgdata(1))->DrvAddress
                drv_sendmessage(src, 4, CPtr(Byte Ptr, @(msgdata(0))) )
            End If

        Case DEVMGRCOMMANDS_SETLOCATION ' Set device location
            If msgdata(1) >= Devcount Then
            ElseIf CInt(Devices(msgdata(1))) = 0 Then
            Else
                'if msgdata(1) = 9 Then *Cptr(Byte Ptr, &H30000000 + size) = 0
                Delete Devices(msgdata(1))->LocId
                Devices(msgdata(1))->LocId = new Byte[size-8]
                Devices(msgdata(1))->LocIDsize = size - 8
                Dim lp As Integer
                Dim srcp As Byte Ptr
                srcp = CPtr(Byte Ptr, @(msgdata(2)) )
                For lp = 0 to size - 9
                    Devices(msgdata(1))->LocId[lp] = srcp[lp]
                    '*Cptr(Byte Ptr, &HB8000 + 2 * lp) = srcp[lp]
                Next lp
            End If

        Case DEVMGRCOMMANDS_GETLOCATION ' Get device location
            Dim ident as Byte Ptr
            Dim isize as Integer
            if msgdata(1) >= Devcount Then
                isize = 1
                ident = CPtr(Byte Ptr, @isize) + 1
                '*Cptr(Byte Ptr, &H30000001) = 0
            ElseIf CInt(Devices(msgdata(1))) = 0 Then
                isize = 1
                ident = CPtr(Byte Ptr, @isize) + 1
                '*Cptr(Byte Ptr, &H30000002) = 0
            Else
                isize = Devices(msgdata(1))->LocIDsize
                ident = Devices(msgdata(1))->LocID
                if isize = 0 then
                    isize = 1
                    '*Cptr(Byte Ptr, &H30000002) = 0
                    ident = CPtr(Byte Ptr, @isize) + 1
                end if
            End If
            drv_sendmessage(src, isize, ident)

        Case DEVMGRCOMMANDS_CONNECTIVITY_REQ ' Browse node connectivity
            Dim nodenumber as Integer
            Dim nodecount As Integer
            nodenumber = msgdata(1)
            nodecount = 0
            If nodenumber >= Devcount Then
                nodecount = 0
                ReDim msgdata(3)
            ElseIf CInt(Devices(nodenumber)) = 0 Then
                nodecount = 0
                ReDim msgdata(3)
            Else
                nodecount = Devices(nodenumber)->Nodecount
                ReDim msgdata(nodecount + 3)
            End If

            Dim lp As Integer
            For lp = 0 to Devices(nodenumber)->Nodecount - 1
                msgdata(lp+3) = Devices(nodenumber)->Nodes[lp]
            Next lp

            msgdata(0) = DEVMGRCOMMANDS_CONNECTIVITY_REQ
            msgdata(1) = nodenumber
            msgdata(2) = nodecount
            drv_sendmessage(src, (nodecount + 1) * 4, CPtr(Byte Ptr, @(msgdata(0)) )  )
            
        Case Else

    End Select




End Sub