' Summary: driverfunc.bas
' Management for the driver tables
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purposes
'

#include "drivers.bi"

Function FindDriver(ByRef id As String) As Integer
    Function = FindDriverPrime(id, 0)
End Function

Function FindDriverPrime(ByRef id As String, ByVal offset As Integer) As Integer
    Function = -1

    Dim devi As DEVINFO, devpt As DEVINFO Ptr Ptr, devid As Integer, mydev As DEVINFO Ptr
    Dim tag As DEVSUPPORT, tagpt As DEVSUPPORT Ptr
    devid = offset
    devpt = @devices
    While devpt[devid] <> CPtr(DEVINFO Ptr, 0)
        devi = devpt[devid][0]

        tagpt = devi.devlist
        While tagpt <> CPtr(DEVSUPPORT Ptr, 0)
            tag = tagpt[0]

            If tag.devname = id Then
                Function = devid
                Exit Function
            End If
            tagpt = tag.nextdev
        Wend

        devid = devid + 1
    Wend
End Function

Function QueryDriverSupportPrime(ByRef id as String, ByVal index as Integer) As Integer
    If index < 0 then exit function

    Function = -1
    Dim devi As DEVINFO, devpt As DEVINFO Ptr Ptr, devid As Integer, mydev As DEVINFO Ptr
    Dim tag As DEVSUPPORT, tagpt As DEVSUPPORT Ptr

    devpt = @devices
    devi = devpt[index][0]

    tagpt = devi.devlist
    While tagpt <> CPtr(DEVSUPPORT Ptr, 0)
        tag = tagpt[0]

        If tag.devname = id Then
            Function = index
            Exit Function
        End If
        tagpt = tag.nextdev
    Wend

End Function

Function SelectDriver(ByRef id As String) As Integer
    Function = SelectDriverPrime(id, 0)
End Function

Function SelectDriverPrime(ByRef id As String, ByVal offset As Integer) As Integer
    Dim retval As Integer

    Function = -3
    If len(id) = 22 Then ' pci xxxx:yyyy aa:bb:cc
        If left$(id, 4) = "PCI " Then

            Dim searchkey As String
            ' select by vendor:device
            searchkey = left$(id, 13)
            retval = FindDriverPrime(searchkey, offset)
            If retval >= 0 then
                Function = retval
                Exit Function
            End If
            ' select by classcode
            searchkey = "PCI " + mid$(id, 15, 8)
            retval = FindDriverPrime(searchkey, offset)
            If retval >= 0 then
                Function = retval
                Exit Function
            End If
            searchkey = "PCI " + mid$(id, 15, 5)
            retval = FindDriverPrime(searchkey, offset)
            If retval >= 0 then
                Function = retval
                Exit Function
            End If

            Function = -4
            Exit Function
        End If
    End If

    retval = FindDriverPrime(id, offset)
    If retval >= 0 then
        Function = retval
        Exit Function
    End If

    Function = -2
End Function

Function GetDriverName(ByVal id As Integer) As String
    if id < 0 then
        Function = "(none)"
        Exit Function
    end if

    Dim devi As DEVINFO, devpt As DEVINFO Ptr Ptr, devid As Integer, mydev As DEVINFO Ptr
    devpt = @devices
    devi = devpt[id][0]
    Function = devi.drivername

End Function

Function QueryDriverSupport(ByRef id as String, ByVal index as Integer) As Integer
    Dim retval As Integer

    Function = -3
    If index < 0 then exit function

    If len(id) = 22 Then ' pci xxxx:yyyy aa:bb:cc
        If left$(id, 4) = "PCI " Then
            Dim searchkey As String
            ' select by vendor:device
            searchkey = left$(id, 13)
            retval = QueryDriverSupportPrime(searchkey, index)
            If retval >= 0 then
                Function = retval
                Exit Function
            End If
            ' select by classcode
            searchkey = "PCI " + mid$(id, 15, 8)
            retval = QueryDriverSupportPrime(searchkey, index)
            If retval >= 0 then
                Function = retval
                Exit Function
            End If
            Function = -4
        End If
    End If

    retval = QueryDriverSupportPrime(id, index)
    If retval >= 0 then
        Function = retval
        Exit Function
    End If

    Function = -2
End Function

