; Summary: drivers.asm
; Contains a map of driver information
;
; Author:
;     Marcel Sondaar
;
; License:
;     Public Domain
;

SECTION .data

global device_map
global device_count

device_map:
    DD device_atadisk
    DD device_atactl
    DD device_bga
    ;DD device_cmos ; UDI not wanted for now
    DD device_dospart
    DD device_fat
    DD device_igma
    DD device_mach64
    DD device_trio64
    DD device_verite
    DD device_vga
    DD device_udimach64
    DD device_udivga    

.end:
    DD 0

device_count: DD (device_map.end - device_map) / 4

ALIGN 8

device_vga:
    DB 'stdvga', 0
    TIMES 16 - ($-device_vga) DB 0
    DD .dev1
    DD .arg1

  .dev1:
    DB 'PCI 03:00:00'
    TIMES 16 - ($-.dev1) DB 0
    DD .dev2
  .dev2:
    DB 'ISA VGA'
    TIMES 16 - ($-.dev2) DB 0
    DD 0

  .arg1:
    DB 'Emu mode'
    TIMES 8 DB 0
    DB '0'
    TIMES 15 DB 0
    DD .arg2
  .arg2
    DB 'Linear16'
    TIMES 8 DB 0
    DB '2'
    TIMES 15 DB 0
    DD 0

device_udivga:
    DB 'u_vga', 0
    TIMES 16 - ($-device_udivga) DB 0
    DD device_vga.dev1
    DD device_vga.arg1

device_bga:
    DD 'bga'
    TIMES 16 - ($-device_bga) DB 0
    DD .dev1
    DD 0

  .dev1:
    DB 'PCI 1234:1111'
    TIMES 16 - ($-.dev1) DB 0
    DD 0

device_atactl:
    DD 'atactl'
    TIMES 16 - ($-device_atactl) DB 0
    DD .dev2 ; skip secondary controller due to loader bug
    DD 0

  .dev1:
    DB 'ISA IDE 170'
    TIMES 16 - ($-.dev1) DB 0
    DD .dev2
  .dev2:
    DB 'ISA IDE 1F0'
    TIMES 16 - ($-.dev2) DB 0
    DD .dev3
  .dev3:
    DB 'PCI 01:01'
    TIMES 16 - ($-.dev3) DB 0
    DD 0
    
device_atadisk:     ; non-packet ata drive
    DD 'atadisk'
    TIMES 16 - ($-device_atadisk) DB 0
    DD .dev1
    DD 0

  .dev1:
    DB 'ATA-0'
    TIMES 16 - ($-.dev1) DB 0
    DD .dev2
  .dev2:
    DB 'ATA-1'
    TIMES 16 - ($-.dev2) DB 0
    DD .dev3
  .dev3:
    DB 'ATA-2'
    TIMES 16 - ($-.dev3) DB 0
    DD .dev4
  .dev4:
    DB 'ATA-3'
    TIMES 16 - ($-.dev4) DB 0
    DD .dev5
  .dev5:
    DB 'ATA-4'
    TIMES 16 - ($-.dev5) DB 0
    DD .dev6
  .dev6:
    DB 'ATA-5'
    TIMES 16 - ($-.dev6) DB 0
    DD .dev7
  .dev7:
    DB 'ATA-6'
    TIMES 16 - ($-.dev7) DB 0
    DD .dev8
  .dev8:
    DB 'ATA-7'
    TIMES 16 - ($-.dev8) DB 0
    DD 0

device_cmos:
    DD 'u_cmos'
    TIMES 16 - ($-device_cmos) DB 0
    DD .dev1
    DD 0

  .dev1:
    DB 'CMOS RAM'
    TIMES 16 - ($-.dev1) DB 0
    DD 0

device_trio64: ; S3 Trio32/64/64V/64V+/64V2/DX/GX, S3 ViRGE/VX/DX/GX/GX2/GX2P
    DD 'trio64v'
    TIMES 16 - ($-device_trio64) DB 0
    DD .dev1
    DD 0

  .dev1:
    DB 'PCI 5333:563D' ; S3 ViRGE
    TIMES 16 - ($-.dev1) DB 0
    DD .dev2
  .dev2:
    DB 'PCI 5333:8810' ; Old Trio chips
    TIMES 16 - ($-.dev2) DB 0
    DD .dev3
  .dev3:
    DB 'PCI 5333:8811' ; Old trio chips (Trio64 or Trio32 or Trio64V?)
    TIMES 16 - ($-.dev3) DB 0
    DD .dev4
  .dev4:
    DB 'PCI 5333:8812' ; Aurora64VP
    TIMES 16 - ($-.dev4) DB 0
    DD .dev5
  .dev5:
    DB 'PCI 5333:8814' ; Trio64UVP
    TIMES 16 - ($-.dev5) DB 0
    DD .dev6
  .dev6:
    DB 'PCI 5333:883D' ; ViRGE VX
    TIMES 16 - ($-.dev6) DB 0
    DD .dev7
  .dev7:
    DB 'PCI 5333:8900' ; Trio64V2
    TIMES 16 - ($-.dev7) DB 0
    DD .dev8
  .dev8:
    DB 'PCI 5333:8901' ; Trio64V2/DX or Trio64V2/GX
    TIMES 16 - ($-.dev8) DB 0
    DD .dev9
  .dev9:
    DB 'PCI 5333:8902' ; Plato PX
    TIMES 16 - ($-.dev9) DB 0
    DD .dev10
  .dev10:
    DB 'PCI 5333:8A01' ; ViRGE DX / ViRGE GX
    TIMES 16 - ($-.dev10) DB 0
    DD .dev11
  .dev11:
    DB 'PCI 5333:8A10' ; ViRGE GX2
    TIMES 16 - ($-.dev11) DB 0
    DD .dev12
  .dev12:
    DB 'PCI 5333:8A11' ; ViRGE GX2P
    TIMES 16 - ($-.dev12) DB 0
    DD .dev13
  .dev13:
    DB 'PCI 5333:8A12' ; ViRGE GX2P
    TIMES 16 - ($-.dev13) DB 0
    DD 0

device_verite: ; Rendition Verite V1000/V2x00
    DD 'verite'
    TIMES 16 - ($-device_verite) DB 0
    DD .dev1
    DD 0

  .dev1:
    DB 'PCI 1163:0001'
    TIMES 16 - ($-.dev1) DB 0
    DD .dev2
  .dev2:
    DB 'PCI 1163:2000'
    TIMES 16 - ($-.dev2) DB 0
    DD 0

device_igma:    ; Intel chipset 828xxG and 829xxG graphics
    DD 'gma'
    TIMES 16 - ($-device_igma) DB 0
    DD .dev1
    DD 0

  .dev1:
    DB 'PCI 0000:0000' ; make list
    TIMES 16 - ($-.dev1) DB 0
    DD 0

device_mach64: ; ATI Mach64 and 3D Rage
    DD 'mach64'
    TIMES 16 - ($-device_mach64) DB 0
    DD .dev1
    DD 0

  .dev1:
    DB 'PCI 1002:4354' ; Mach64 CT
    TIMES 16 - ($-.dev1) DB 0
    DD 0

    DB 'PCI 1002:4358' ; Mach64 CX
    DB 'PCI 1002:4554' ; Mach64 ET
    DB 'PCI 1002:4654' ; Mach64 VT (#1)
    DB 'PCI 1002:4754' ; Mach64 GT
    DB 'PCI 1002:4758' ; Mach64 GX
    DB 'PCI 1002:4C54' ; Mach64 LT
    DB 'PCI 1002:5654' ; Mach64 VT (#2)
    DB 'PCI 1002:5655' ; Mach64 VT3
    DB 'PCI 1002:5656' ; Mach64 VT4

    DB 'PCI 1002:4742' ; 3D Rage Pro AGP 1X/2X
    DB 'PCI 1002:4744' ; 3D Rage Pro AGP 1X
    DB 'PCI 1002:4747' ; 3D Rage Pro PCI
    DB 'PCI 1002:4749' ; 3D Rage Pro PCI
    DB 'PCI 1002:474C' ; 3D Rage XC PCI
    DB 'PCI 1002:474D' ; 3D Rage XL AGP2X
    DB 'PCI 1002:474E' ; 3D Rage XC AGP
    DB 'PCI 1002:474F' ; 3D Rage XL PCI
    DB 'PCI 1002:4750' ; 3D Rage Pro GP
    DB 'PCI 1002:4751' ; 3D Rage Pro GQ
    DB 'PCI 1002:4752' ; 3D Rage XL PCI
    DB 'PCI 1002:4753' ; 3D Rage XC
    DB 'PCI 1002:4755' ; 3D Rage II+
    DB 'PCI 1002:4756' ; 3D Rage IIC
    DB 'PCI 1002:4757' ; 3D Rage IIC AGP
    DB 'PCI 1002:4759' ; 3D Rage IIC
    DB 'PCI 1002:475A' ; 3D Rage IIC AGP
    DB 'PCI 1002:4C42' ; 3D Rage LT Pro AGP-133
    DB 'PCI 1002:4C44' ; 3D Rage LT Pro AGP-66
    DB 'PCI 1002:4C45' ; 3D Rage Mobility M3
    DB 'PCI 1002:4C46' ; 3D Rage Mobility M3 AGP
    DB 'PCI 1002:4C47' ; 3D Rage LT
    DB 'PCI 1002:4C49' ; 3D Rage LT Pro

device_udimach64: ; ATI Mach64 and 3D Rage
    DD 'u_mach'
    TIMES 16 - ($-device_udimach64) DB 0
    DD device_mach64.dev1
    DD 0
    
device_dospart:
    DD 'dospart'
    TIMES 16 - ($-device_dospart) DB 0
    DD .dev1
    DD 0

  .dev1:
    DB 'FS DOSPART'
    TIMES 16 - ($-.dev1) DB 0
    DD 0
    
    
device_fat:
    DD 'fat'
    TIMES 16 - ($-device_fat) DB 0
    DD .dev1
    DD 0

  .dev1:
    DB 'FS VFAT'
    TIMES 16 - ($-.dev1) DB 0
    DD 0
