
#include <mos/event.h>
#include <stdlib.h>

void mos_resize_insert(MOS_EVENTHANDLER_ROOT * root, uint32_t slot, int (*callback)(void *, unsigned int, unsigned int, unsigned char *), void * data)
{
    int seg = slot >> 16;
    int index = slot & 0xffff;
    
    
    if (!(seg & 0x80000000) && (root->max_roots <= seg))
    {
        int newsize = seg+1;
        MOS_EVENTHANDLER_TREE * newroot;
        if (root->sys_trees != NULL)
        {
            newroot = (MOS_EVENTHANDLER_TREE *) realloc(root->sys_trees, newsize * sizeof(MOS_EVENTHANDLER_TREE));
        }
        else 
        {
            newroot = (MOS_EVENTHANDLER_TREE *) malloc(newsize * sizeof(MOS_EVENTHANDLER_TREE));
        }
        
        int currentindex = root->max_roots;
        for (; currentindex < newsize ; currentindex++)
        {
            newroot[currentindex].max_message_sub = 0;
            newroot[currentindex].handles = NULL;
        }
        root->sys_trees = newroot;
        root->max_roots = newsize;
    }

    if (root->sys_trees[seg].max_message_sub <= index)
    {
        int newsize = index+1;
        MOS_EVENTHANDLER * newhandles;
        if (root->sys_trees[seg].handles != NULL)
        {
            newhandles = (MOS_EVENTHANDLER *) realloc(root->sys_trees[seg].handles, newsize * sizeof(MOS_EVENTHANDLER));
        }
        else
        {
            newhandles = (MOS_EVENTHANDLER *) malloc(newsize * sizeof(MOS_EVENTHANDLER));
        }
        
        int currentindex = root->sys_trees[seg].max_message_sub;
        for ( ; currentindex < newsize; currentindex++)
        {
            newhandles[currentindex].callback = NULL;
            newhandles[currentindex].data = NULL;            
        }
        root->sys_trees[seg].handles = newhandles;
        root->sys_trees[seg].max_message_sub = newsize;
    }
    
    root->sys_trees[seg].handles[index].data = data;
    root->sys_trees[seg].handles[index].callback = callback;
}
