' Summary: finddev.bas
' Finds devices with certain interfaces
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purporses
'

#include "mos/drivercom.bi"
#include "mos/driver.bi"
#include "mos/event.bi"
#include "mos.bi"

Function mos_finddev CDecl Alias "mos_finddev" (ByVal Interface As Integer) As Integer

    Dim devaddr As Integer

    Dim drvindex As Integer
    drvindex = 1
    While devaddr = 0

        Dim senddata(0 to 2) As Integer
        senddata(0) = 2
        senddata(1) = drvindex
        drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(senddata(0))) )

        While drv_peekmessage() = 0
            Yield
        Wend

        Dim rv As Integer
        rv = drv_peekmessage()
        Dim rs As Byte Ptr
        rs = eventdata_alloc(rv)
        drv_readmessage(rs)
        eventdata_free(rs)

        If (rv > 1) Then
            senddata(0) = 8
            senddata(1) = drvindex
            drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(senddata(0))) )
            While drv_peekmessage() = 0
                Yield
            Wend
            drv_readmessage( CPtr(Byte Ptr, @(senddata(0))))

            If senddata(0) <> 0 Then
                devaddr = senddata(0)

                ' query for the graphics2 interface
                senddata(0) = SYSCOMMAND_QUERYINTERFACES
                drv_sendmessage(devaddr, 4, CPtr(Byte Ptr, @(senddata(0))) )
                While drv_peekmessage() = 0
                    Yield
                Wend
                rv = drv_peekmessage()
                rs = eventdata_alloc(rv + 3)
                drv_readmessage(rs)

                Dim msgdata As Integer Ptr
                msgdata = CPtr(Integer Ptr, rs)

                ' test if we can use it
                Dim ok as Integer, lp as Integer
                ok = 0
                For lp = 0 To (rv \ 4) - 1
                    If msgdata[lp] = Interface Then ok = 1
                Next lp
                eventdata_free(rs)
                If ok = 0 Then
                    devaddr = 0
                    drvindex = drvindex + 1
                Else
                    Function = devaddr
                    Exit Function
                End If
            Else
                drvindex = drvindex + 1
            End If
        Else
	    drvindex = 1
	    Yield
            Function = 0
            'Exit Function
        End If

    Wend

End Function

