/*
        Summary: hosted_event.c
        *A hosted event loop, designed to automatically stop when out of messages*

        Author:
            Marcel Sondaar

        License:
            Educational Purposes
*/

#include <mos/event.h>
#include <mos/drivercom.h>
#include <stdlib.h>

int mos_eventloop_prime(MOS_EVENTHANDLER_ROOT * handleroot)
{
    int retval = 0;
    while (!retval)
    {
        int msglen = drv_peekmessage();
        if (msglen == 0) return 0;

        unsigned char * message = (unsigned char *) malloc(msglen);        
        if (!message) return -2;

        int sender = drv_readmessage((char*)message);
        __asm volatile("xchgw %bx, %bx\n xchg %cx, %cx");
        if (msglen >= 4)
        {
            uint32_t messageid = *((uint32_t*)message);
            if ((messageid & 0xffff0000) == 0xffff0000)
            {
                // user-defined message
                if (!handleroot->user_tree)
                    retval = handleroot->errorhandler(sender, msglen, message);
                else if ((messageid & 0xffff) >= handleroot->user_tree->max_message_sub)
                    retval = handleroot->errorhandler(sender, msglen, message);
                else
                    retval = handleroot->user_tree->handles[messageid & 0xffff].callback(handleroot->user_tree->handles[messageid & 0xffff].data, sender, msglen, message);

            }
            else
            {
                // system-defined message
                if ((messageid >> 16) > (handleroot->max_roots))
                    retval = handleroot->errorhandler(sender, msglen, message);
                else if (!handleroot->sys_trees)
                    retval = handleroot->errorhandler(sender, msglen, message);
                else if ((messageid & 0xffff) >= handleroot->sys_trees[messageid >> 16].max_message_sub)
                    retval = handleroot->errorhandler(sender, msglen, message);
                else
                    retval = handleroot->sys_trees[messageid >> 16].handles[messageid & 0xffff].callback(handleroot->sys_trees[messageid >> 16].handles[messageid & 0xffff].data, sender, msglen, message);
            }
        }
        if (retval) __asm volatile("xchgw %%bx, %%bx\nxchgw %%si, %%si" : : : "memory");
        free(message);
    }
    return retval;
}

