#include "idltool.h"
#include <stdio.h>
#include <ctype.h>

static void write_ucase(FILE * out, const char * string)
{
    while (*string)
    {
        fputc(toupper(*string++), out);
    }    
}

static void write_lcase(FILE * out, const char * string)
{
    while (*string)
    {
        fputc(tolower(*string++), out);
    }    
}

int idl_emit_bas_receiver(FILE * out, IDL_CHANNEL * data, IDL_MESSAGE * message)
{
    fprintf(out, "Function dispatch_%s_%s CDecl(ByVal _thisptr As MCChannelListener Ptr, ByVal _sender As Integer, ByVal _length As Integer, ByVal _contents As Byte Ptr) As Integer\n",
                  data->interface_name, message->message_name);
    fprintf(out, "    Dim _listener As %sListener Ptr\n", data->interface_name);
    fprintf(out, "    _listener = CPtr(%sListener Ptr, _thisptr)\n\n", data->interface_name);
    
    int len = 4;
    int fixed = 1;
    IDL_PARAM * param = message->params;
    while (param)
    {
        switch(param->param_type << 8)
        {
            case DATA_8:    
                fprintf(out, "    Dim %s As Unsigned Byte\n", param->param_name);
                len = len + 1; 
                break;
            case DATA_16:
                fprintf(out, "    Dim %s As Unsigned Short\n", param->param_name);
                len = len + 2; 
                break;
            case DATA_32:
                fprintf(out, "    Dim %s As Unsigned Integer\n", param->param_name);
                len = len + 4; 
                break;
            case DATA_64:
                fprintf(out, "    Dim %s As Unsigned Long\n", param->param_name);
                len = len + 8; 
                break;
            case DATA_STR:  
                fprintf(out, "    Dim _length_%s As Unsigned Integer\n", param->param_name);
                fprintf(out, "    Dim _offset_%s As Unsigned Integer\n", param->param_name);
                fprintf(out, "    Dim %s As String\n", param->param_name);
                len = len + 4; 
                fixed = 0;
                break;
                            
        }        
        param = (IDL_PARAM *) param->next;
    }
        
    fprintf(out, "    If _length %s %i Then\n"
                 "        Function = 1\n"
                 "        Exit Function\n"
                 "    End If\n\n",
                 (fixed ? "<>" : "<"),
                 len);
    
    if (!fixed)
    {
        fprintf(out, "    Dim _expected_length As Integer\n"                     
                     "    _expected_length = %i\n",                     
                     len);
    
    }
    
    // read the first block of arguments
    int offset = 4;
    param = message->params;
    while (param)
    {
        switch(param->param_type << 8)
        {
            case DATA_8:    fprintf(out, "    %s = *Cptr(Unsigned Byte Ptr, @(_contents[%i]))\n", param->param_name, offset);
                            offset = offset + 1; 
                            break;
                            
            case DATA_16:   fprintf(out, "    %s = *Cptr(Unsigned Short Ptr, @(_contents[%i]))\n", param->param_name, offset);
                            offset = offset + 2; 
                            break;
                            
            case DATA_32:   fprintf(out, "    %s = *Cptr(Unsigned Integer Ptr, @(_contents[%i]))\n", param->param_name, offset);
                            offset = offset + 4; 
                            break;
                            
            case DATA_64:   fprintf(out, "    %s = *Cptr(Unsigned Long Ptr, @(_contents[%i]))\n", param->param_name, offset);
                            offset = offset + 8; 
                            break;
                            
            case DATA_STR:  fprintf(out, "    _length_%s = *Cptr(Unsigned Integer Ptr, @(_contents[%i]))\n", param->param_name, offset);
                            fprintf(out, "    _offset_%s = _expected_length\n", param->param_name);
                            fprintf(out, "    _expected_length = _expected_length + _length_%s\n", param->param_name);
                            
                            offset = offset + 4; 
                            break;
                            
        }        
        param = (IDL_PARAM *) param->next;
    }
    fprintf(out, "\n");
    
    if (!fixed)
    {
        fprintf(out, "    If _length <> _expected_length Then\n"
                     "        Function = 1\n"
                     "        Exit Function\n"
                     "    End If\n\n"
                     "    Dim _l As Integer\n"
        );
    }

    // variable-size buffer stuff
    param = message->params;
    while (param)
    {
        switch(param->param_type << 8)
        {
            case DATA_STR:
                fprintf(out, "    For _l = _offset_%s to _offset_%s + _length_%s\n"
                             "        %s = %s + chr$(_contents[_l])\n"
                             "    Next _l\n",
                             param->param_name, param->param_name, param->param_name, param->param_name, param->param_name);
                break;
                
            default:
                break;
                // do nothing
        }        
        param = (IDL_PARAM *) param->next;
    }

    // dispatch
    fprintf(out, "\n    _listener->%s CPtr(Byte Ptr, _sender)", message->message_name); 
    param = message->params;
    while (param)
    {
        fprintf(out, ", %s", param->param_name);
	param = (IDL_PARAM *) param->next;
    }
    fprintf(out, "\n\n");
    
    fprintf(out, "    Function = 0\n");
    
    fprintf(out, "End Function\n\n");
    
    fprintf(out, "Sub %sListener.%s(ByVal _channel As Byte Ptr", data->interface_name, message->message_name);
    if (message->params != NULL) fprintf(out, ", ");
    idl_emit_bas_args(out, message->params);
    fprintf(out, ")\n");
    fprintf(out, "    *CPtr(Byte Ptr, &HE1700000) = 0\n");
    fprintf(out, "End Sub\n\n");        
    
    return 0;
}

int idl_emit_bas_sender(FILE * out, IDL_CHANNEL * data, IDL_MESSAGE * message)
{
    fprintf(out, "Sub %s_%s (ByVal channel As Byte Ptr", data->interface_name, message->message_name);
    if (message->params)
    {
        fprintf(out, ", ");
        idl_emit_bas_args(out, message->params);
    }
    fprintf(out, ")\n");
    
    fprintf(out, "    Dim _message_length As Integer\n"
                 "    _message_length = ");
                
    int len = 4;
    IDL_PARAM * param = message->params;
    while (param)
    {
        switch(param->param_type << 8)
        {
            case DATA_8:    len = len + 1; break;
            case DATA_16:   len = len + 2; break;
            case DATA_32:   len = len + 4; break;
            case DATA_64:   len = len + 8; break;
            case DATA_STR:  
                len = len + 4; // storing the length
                fprintf(out, "Len(%s) + ", param->param_name);
                break;

            default: 
                fprintf(stderr, "BUG: missing type implementation: %i\n", param->param_type);
                return 1;
        }        
        param = (IDL_PARAM *) param->next;
    }
    fprintf(out, "%i\n", len);
    fprintf(out, "    Dim _message() As Byte\n"
                 "    Redim _message(_message_length)\n"
                 "    Dim _endpointer As Integer, _i As Integer, _l As Integer\n"
                 "    _endpointer = %i\n\n", len);
    
    // message id
    fprintf(out, "    *Cptr(Unsigned Integer Ptr, @(_message(0))) = ");
    write_ucase(out, data->interface_name);
    fprintf(out, "COMMAND_");
    write_ucase(out, message->message_name);
    fprintf(out, "\n\n");
    
    int offset = 4;
    param = message->params;
    while (param)
    {
        switch(param->param_type << 8)
        {
            case DATA_8:    fprintf(out, "    *Cptr(Unsigned Byte Ptr, @(_message(%i))) = %s\n", offset, param->param_name);
                            offset = offset + 1; 
                            break;
                            
            case DATA_16:   fprintf(out, "    *Cptr(Unsigned Short Ptr, @(_message(%i))) = %s\n", offset, param->param_name);
                            offset = offset + 2; 
                            break;
                            
            case DATA_32:   fprintf(out, "    *Cptr(Unsigned Integer Ptr, @(_message(%i))) = %s\n", offset, param->param_name);
                            offset = offset + 4; 
                            break;
                            
            case DATA_64:   fprintf(out, "    *Cptr(Unsigned Long Ptr, @(_message(%i))) = %s\n", offset, param->param_name);
                            offset = offset + 8; 
                            break;
            case DATA_STR:  
                fprintf(out, "    _l = Len(%s)\n", param->param_name);
                fprintf(out, "    *Cptr(Unsigned Integer Ptr, @(_message(%i))) = _l\n", offset);
                fprintf(out, "    For _i = 0 to _l - 1\n"
                             "        _message(_endpointer + _i) = Asc(Mid$(%s, _i, 1))\n"
                             "    Next _i\n"
                             "    _endpointer = _endpointer + _l\n",
                             param->param_name);
                offset = offset + 4; // storing the length                
                break;

            default: 
                fprintf(stderr, "BUG: missing type implementation: %i\n", param->param_type);
                return 1;
        }        
        param = (IDL_PARAM *) param->next;
    }
    
    fprintf(out, "    \n"
                 "    drv_sendmessage CInt(channel), _message_length, CPtr(Byte Ptr, @(_message(0)))\n");
    
    fprintf(out, "End Sub\n\n");
    return 0;
}

int idl_emit_bas_constructor(FILE * out, IDL_CHANNEL * data)
{
    fprintf(out, "Constructor %sListener\n", data->interface_name);
    IDL_MESSAGE * message = data->messages;

    while (message)
    {
        fprintf(out, "    SetHandler(");
	write_ucase(out, data->interface_name);
        fprintf(out, "COMMAND_");
        write_ucase(out, message->message_name);
        fprintf(out, ", @dispatch_%s_%s)\n", data->interface_name, message->message_name);

        message = (IDL_MESSAGE *)message->next;
    }

    fprintf(out, "End Constructor\n\n");
    return 0;
}
    

int idl_emit_bas(FILE * out, IDL_CHANNEL * data)
{
    fprintf(out, "' Automatically generated by idltool\n' Do not modify\n\n");

    fprintf(out, "#include \"mos/channel.bi\"\n");
    fprintf(out, "#include \"mos/drivercom.bi\"\n");
    fprintf(out, "#include \"");

    if (!data)
    { 
        fprintf(stderr, "Error: no protocols defined\n");
        return 1;
    }
    write_lcase(out, data->interface_name);    
    fprintf(out, ".bi\"\n"
                 "#include \"mos/"
    );
    write_lcase(out, data->interface_name);    
    fprintf(out, "_ids.bi\"\n\n");

    while (data)
    {
        int retval;

	fprintf(out, "Destructor %sListener\n", data->interface_name);
        
        fprintf(out, "End Destructor\n\n");
        
        IDL_MESSAGE * message = data->messages;
        while (message)
        {
            retval = idl_emit_bas_receiver(out, data, message);
            if (retval) return retval;
            retval = idl_emit_bas_sender(out, data, message);
            if (retval) return retval;
            
            message = (IDL_MESSAGE *) message->next;
        }

	retval = idl_emit_bas_constructor(out, data);
	if (retval) return retval;

        data = (IDL_CHANNEL *) data->next;
    }
    
    
    return 0;
}
