#include "idltool.h"
#include <stdio.h>

int idl_emit_bi(FILE * out, IDL_CHANNEL * data)
{
    fprintf(out, "' Automatically generated by idltool\n' Do not modify\n\n");

    fprintf(out, "#include \"mos/channel.bi\"\n\n");
    
    IDL_CHANNEL * origdata = data;

    while (data)
    {
        fprintf(out, "' Generated from protocol %s\n"
                     "Type %sListener Extends MCChannelListener\n"
                     "    Declare Constructor()\n"
                     "    Declare Destructor()\n",
                data->interface_name, data->interface_name);

        IDL_MESSAGE * message = data->messages;
        while (message)
        {
                fprintf(out, "    Declare Virtual Sub %s (ByVal channel As Byte Ptr", message->message_name);
            // add arguments here
            IDL_PARAM * param = (IDL_PARAM *) message->params;
            while (param)
            {
                fprintf(out, ", ");
                const char * typestring = "";
                const char * typeabi = "ByVal"; 
                switch(param->param_type << 8)
                {
                    case DATA_8:    typestring = "Unsigned Byte"; break;
                    case DATA_16:   typestring = "Unsigned Short"; break;
                    case DATA_32:   typestring = "Unsigned Integer"; break;
                    case DATA_64:   typestring = "Unsigned Long"; break;
                    case DATA_STR:  typestring = "String"; typeabi = "ByRef"; break;

                    default: 
                        fprintf(stderr, "BUG: missing type implementation: %i\n", param->param_type);
                        return 1;
                }

                fprintf(out, "%s %s As %s", typeabi, param->param_name, typestring);
                param = (IDL_PARAM *)param->next;
            }
            fprintf(out, ")\n");
            message = message->next;
        }

        fprintf(out, "End Type\n\n");
        data = data->next;
    }

    data = origdata;
    fprintf(out, "'\n' Send functions\n'\n");
    while (data)
    {
        IDL_MESSAGE * message = data->messages;
        while (message)
        {
            fprintf(out, "Declare Sub %s_%s (ByVal channel As Byte Ptr",
            data->interface_name, message->message_name);

            if (message->params)
            {
                fprintf(out, ", ");
                int retval = idl_emit_bas_args(out, message->params);
                if (retval) return retval;
            }

            fprintf(out, ")\n");
            message = message->next;
        }
        data = data->next;
    }

    return 0;
}

int idl_emit_bas_args(FILE * out, IDL_PARAM * param)
{
    while (param)
    {
        const char * typestring = "";
        const char * typeabi = "ByVal"; 
        switch(param->param_type << 8)
        {
            case DATA_8:    typestring = "Unsigned Byte"; break;
            case DATA_16:   typestring = "Unsigned Short"; break;
            case DATA_32:   typestring = "Unsigned Integer"; break;
            case DATA_64:   typestring = "Unsigned Long"; break;
            case DATA_STR:  typestring = "String"; typeabi = "ByRef"; break;

            default: 
                fprintf(stderr, "BUG: missing type implementation: %i\n", param->param_type);
                return 1;
        }

        fprintf(out, "%s %s As %s", typeabi, param->param_name, typestring);                
        param = (IDL_PARAM *) param->next;
        if (param)
        {
            fprintf(out, ", ");
        }
    }
    return 0;
}
