/**
 * Summary: idlemit_udih.c
 * IDL-to-code emitter for receiver glue
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include "idltool.h"
#include <stdio.h>
#include <ctype.h>

int idl_emit_udih_structargs(FILE * out, IDL_PARAM * tree)
{
    while (tree)
    {        
        switch (tree->param_type)
        {
            case (DATA_8 >> 8):  fprintf(out, "    udi_ubit8_t %s;\n",  tree->param_name); break;
            case (DATA_16 >> 8): fprintf(out, "    udi_ubit16_t %s;\n", tree->param_name); break;
            case (DATA_32 >> 8): fprintf(out, "    udi_ubit32_t %s;\n", tree->param_name); break;
            case (DATA_STR >> 8):fprintf(out, "    udi_size_t %s;\n",   tree->param_name); break;

            case (DATA_TUPLE >> 8):
            {
                int retval = idl_emit_udih_structargs(out, tree->child);
                if (retval) return retval;
                break;
            }
            
            default:
                fprintf(stderr, "BUG: unknown data type %i", tree->param_type);
                return 2;
        }
        tree = tree->next;
    }
    return 0;
}

int idl_emit_udih_block(FILE * out, IDL_CHANNEL * data)
{
    fprintf(out, "void udienv_register_%s(MOS_EVENTHANDLER_ROOT * handler, udi_%s_ops_t * ops, mos_region_t * region);\n",
        data->interface_name,
        data->interface_name);
    
    IDL_MESSAGE * message = data->messages;
    while (message)
    {
        //fprintf(out, "Function dispatch_%s_%s CDecl(ByVal _thisptr As MCChannelListener Ptr, ByVal _sender As Integer, ByVal _length As Integer, ByVal _contents As Byte Ptr) As Integer\n",
        //          data->interface_name, message->message_name);
        
        fprintf(out, "int udienv_dispatch_%s(void * user, unsigned int sender, unsigned int length, udi_ubit8_t * data);\n",
                message->message_name);
        fprintf(out, "typedef struct udienv_marshal_%s\n"
                     "{\n"
                     "    udi_ubit32_t _function_id;\n"
                     "    intptr_t _reply_id;\n",
                message->message_name);
        
        int retval = idl_emit_udih_structargs(out, message->params);
        if (retval) return retval;
        
        fprintf(out, "} udienv_marshal_%s_t;\n\n", message->message_name);
        
        
        message = message->next;
    }
    return 0;
}

int idl_emit_udih(FILE * out, IDL_CHANNEL * data)
{
    fprintf(out, "// Automatically generated by idltool\n// Do not modify\n\n");

    fprintf(out, "#define UDI_VERSION 0x101\n"
                 "#include <udi.h>\n"
		 "#include <udi_env.h>\n");
    // TODO: implement stuff to generate this properly
    fprintf(out, "#define UDI_GFX_VERSION 0x101\n"
                 "#include <udi_gfx.h>\n");
    fprintf(out, "#define UDI_NIC_VERSION 0x101\n"
                 "#include <udi_nic.h>\n");
    fprintf(out, "#define UDI_FS_VERSION 0x101\n"
                 "#include <udi_fs.h>\n");   

    fprintf(out, "\n#include <mos/event.h>\n\n");

    if (!data)
    { 
        fprintf(stderr, "Error: no protocols defined\n");
        return 1;
    }        
    
    while (data)
    {
        int retval = idl_emit_udih_block(out, data);
        if (retval) return retval;
        data = data->next;
    }
        
    fprintf(out, "\n");            
    
    return 0;
}
