/**
 * Summary: idlemit_uditx.c
 * IDL-to-code emitter for transmitters from UDI land
 *
 * Author:
 *     Marcel Sondaar
 *
 * License:
 *     <Public Domain>
 */

#include "idltool.h"
#include <stdio.h>
#include <ctype.h>

static void write_ucase(FILE * out, const char * string)
{
    while (*string)
    {
        fputc(toupper(*string++), out);
    }    
}

static void write_lcase(FILE * out, const char * string)
{
    while (*string)
    {
        fputc(tolower(*string++), out);
    }    
}

/*
int idl_emit_udirx_sizecount(FILE * out, IDL_PARAM * param)
{
    while (param)
    {
        switch (param->param_type << 8)
        {
            case DATA_STR:            
                fprintf(out, " + _convdata->%s", param->param_name);
                break;
            
            case DATA_TUPLE:            
                idl_emit_udirx_sizecount(out, param->child);
                break;
            
            default:
                break;
        }
        param = param->next;
    }
    return 0;
}
*/

int idl_emit_uditx_dispatch(FILE * out, IDL_CHANNEL * data, IDL_MESSAGE * message)
{     
    fprintf(out, "void udi_%s(",
                message->message_name);
    IDL_PARAM * param = message->params;
    int first = 1;
    while (param)
    {
        if (first)
        {
            first = 0;
        }
        else
        {
            fprintf(out, ", ");
        }
        
        switch (param->param_type << 8)
        {
            case DATA_8:
                fprintf(out, "udi_ubit8_t %s", param->param_name);
                break;
            case DATA_16:
                fprintf(out, "udi_ubit16_t %s", param->param_name);
                break;
            case DATA_32:
                fprintf(out, "udi_ubit32_t %s", param->param_name);
                break;
           
            case DATA_STR:
	        fprintf(out, "udi_buf_t * %s", param->param_name);
		break;

            case DATA_TUPLE:
                fprintf(out, "%s * %s", param->param_customtype, param->param_name);
                break;
                
            default:
                fprintf(stderr, "BUG: unsupported type %i in argument %s\n", param->param_type, param->param_name);
                return 1;
        }
        param = param->next;
    }
    fprintf(out, ")\n"
                 "{\n"
                 "    udi_size_t _transmit_length = sizeof(udienv_marshal_%s_t);\n",
                 message->message_name);
    
    param = message->params;
    while (param)
    {
        switch (param->param_type << 8)
        {
            case DATA_STR:
	        fprintf(out, "    udi_size_t _offset_%s = _transmit_length;\n",
		        param->param_name);
                fprintf(out, "    _transmit_length += (%s != NULL) ? %s->buf_size : 0;\n",
		        param->param_name, param->param_name);
	        break;

            case DATA_TUPLE:
	    case DATA_8:
	    case DATA_16:
	    case DATA_32:
	        break;

            default:
	        fprintf(stderr, "BUG: unsupported type %i in argument %s\n", param->param_type, param->param_name);
                return 1;


	}

        param = param->next;
    }
        
    fprintf(out, "    udi_ubit8_t * _tx_buffer = (udi_ubit8_t *) malloc(_transmit_length);\n"
                 "    udi_assert(_tx_buffer != NULL);\n"
                 "    udi_ubit8_t * _tx_objects = _tx_buffer;\n"
                 "    udienv_marshal_%s_t * _tx_cb = (udienv_marshal_%s_t *) _tx_objects;\n\n",
                 message->message_name,
                 message->message_name);
    
    param = message->params;
    if (param == NULL || (param->param_type << 8) != DATA_TUPLE)
    {
        fprintf(stderr, "BUG: UDI expects a control block in the first argument of %s\n", message->message_name);
        return 1;
    }
    
    param = param->child;
    while (param)
    {
        switch (param->param_type << 8)
        {
            case DATA_8:
            case DATA_16:
            case DATA_32:
                fprintf(out, "    _tx_cb->%s = cb->%s;\n", param->param_name, param->param_name);
                break;            
                            
            default:
                fprintf(stderr, "BUG: unsupported type %i in argument %s\n", param->param_type, param->param_name);
                return 1;
        }
        param = param->next;
    }
    param = message->params->next;
    while (param)
    {
        switch (param->param_type << 8)
        {
            case DATA_8:
            case DATA_16:
            case DATA_32:
                fprintf(out, "    _tx_cb->%s = %s;\n", param->param_name, param->param_name);
                break;

	    case DATA_STR:
	        fprintf(out, "    _tx_cb->%s = (%s == NULL) ? 0 : (%s->buf_size);\n",
		        param->param_name, param->param_name, param->param_name);
		fprintf(out, "    _udi_buf_exit(%s, ((udi_ubit8_t*)_tx_cb) + _offset_%s);\n",
		        param->param_name, param->param_name);
		break;

            default:
                fprintf(stderr, "BUG: unsupported type %i in argument %s\n", param->param_type, param->param_name);
                return 1;
        }
        param = param->next;
    }
    
    fprintf(out, "    mos_system_cb_t * syscb = _udi_cb_system(UDI_GCB(cb));\n"
                 "    _tx_cb->_reply_id = syscb->requestindex;\n");
    
    fprintf(out, "    _tx_cb->_function_id = ");
    write_ucase(out, message->message_name);
    fprintf(out, "_MESSAGE_ID;\n\n");
    
    fprintf(out, "    drv_sendmessage(syscb->origin, _transmit_length, (char *) _tx_buffer);\n"
                 "    free(_tx_buffer);\n"
                 "    _udi_cb_exit(UDI_GCB(cb));\n");
        
    fprintf(out, "}\n\n");
    
    return 0;    
}
    

int idl_emit_uditx(FILE * out, IDL_CHANNEL * origdata)
{
    fprintf(out, "// Automatically generated by idltool\n// Do not modify\n\n");    

    if (!origdata)
    { 
        fprintf(stderr, "Error: no protocols defined\n");
        return 1;
    }
    
    fprintf(out, "#include \"");    
    write_lcase(out, origdata->interface_name);
    fprintf(out, ".h\"\n");
    
    fprintf(out, "#include \"mos/");
    write_lcase(out, origdata->interface_name);    
    fprintf(out, "_ids.h\"\n\n");    

    fprintf(out, "#include <udi_env.h>\n");
    fprintf(out, "#include <stdlib.h>\n");
    fprintf(out, "#include <mos/event.h>\n");
    fprintf(out, "#include <mos/drivercom.h>\n");
    fprintf(out, "void bochs_puts(const char * s);\n");
    
    IDL_CHANNEL * data = origdata;
    while (data)
    {
        int retval;
        
        IDL_MESSAGE * message = data->messages;
        while (message)
        {
            retval = idl_emit_uditx_dispatch(out, data, message);
            if (retval) return retval;
            
            message = (IDL_MESSAGE *) message->next;
        }
        data = (IDL_CHANNEL *) data->next;
    }    
    
    return 0;
}
