#ifndef _IDLTOOL_H_
#define _IDLTOOL_H_

#include <stdint.h>
#include <stdio.h>

#define TYPE_EOF                0
#define TYPE_KEYWORD_MESSAGE    1
#define TYPE_KEYWORD_PROTOCOL   2
#define TYPE_KEYWORD_TYPE       3
#define TYPE_NAME               4
#define TYPE_COMMENT            5
#define TYPE_BLOCKSTART         6
#define TYPE_BLOCKEND           7
#define TYPE_KEYWORD_STRUCT     8

#define EMIT_PRETTY             0
#define EMIT_B_IMPL             1
#define EMIT_B_HEADER           2
#define EMIT_C_WRAP             3
#define EMIT_C_HEADER           4
#define EMIT_CPP_HEADER         5
#define EMIT_UDI_HEADER         6
#define EMIT_UDI_RECEIVER       7
#define EMIT_UDI_TRANSMITTER    8
#define EMIT_UDI_STANDARD       9

#define DATA_8                  0x100
#define DATA_16                 0x200
#define DATA_32                 0x300
#define DATA_64                 0x400
#define DATA_STR                0x500
#define DATA_TUPLE              0x600


typedef struct IDL_LEX
{
    int type;
    char * content;
    void * next;
} IDL_LEX;

typedef struct IDL_PARAM
{
    struct IDL_PARAM * next;
    struct IDL_PARAM * child;
    char * param_name;
    char * param_customtype;
    int param_type;
} IDL_PARAM;

typedef struct IDL_MESSAGE
{
    uint32_t message_id;
    char * message_name;
    IDL_PARAM * params;
    void * next;
} IDL_MESSAGE;

typedef struct IDL_CHANNEL
{
    uint32_t interface_id;
    char * interface_name;
    IDL_MESSAGE * messages;
    void * next;
} IDL_CHANNEL;

IDL_LEX     * idl_lexer(const char * input);
void          idl_freelex(IDL_LEX * lex);
IDL_CHANNEL * idl_parser(IDL_LEX * lex);
void          idl_freeparse(IDL_CHANNEL * parse);
void          idl_freemessage(IDL_MESSAGE * message);
void          idl_freeparam(IDL_PARAM * param);
IDL_CHANNEL * idl_parse_channel(IDL_LEX ** lexptr);
IDL_MESSAGE * idl_parse_message(IDL_LEX ** lexptr);
IDL_PARAM *   idl_parse_param(IDL_LEX ** lexptr, int * ok);

int           idl_emit_bi(FILE * out, IDL_CHANNEL * data);
int           idl_emit_bas(FILE * out, IDL_CHANNEL * data);
int           idl_emit_udih(FILE * out, IDL_CHANNEL * data);
int           idl_emit_udidef(FILE * out, IDL_CHANNEL * data);
int           idl_emit_udirx(FILE * out, IDL_CHANNEL * data);
int           idl_emit_uditx(FILE * out, IDL_CHANNEL * data);

int           idl_emit_bas_sender(FILE * out, IDL_CHANNEL * data, IDL_MESSAGE * message);
int           idl_emit_bas_receiver(FILE * out, IDL_CHANNEL * data, IDL_MESSAGE * message);
int           idl_emit_bas_args(FILE * out, IDL_PARAM * param);

int           idl_emit_udih_block(FILE * out, IDL_CHANNEL * data);
int           idl_emit_udidef_block(FILE * out, IDL_CHANNEL * data);
int           idl_emit_udidef_message(FILE * out, IDL_CHANNEL * data, IDL_MESSAGE * message);
int           idl_emit_udirx_dispatch(FILE * out, IDL_CHANNEL * data, IDL_MESSAGE * message);
int           idl_emit_uditx_dispatch(FILE * out, IDL_CHANNEL * data, IDL_MESSAGE * message);
#endif
