' Summary: procmgr.bas
' Manages Processes
'
' Author:
'     Marcel Sondaar
'
' License:
'     Educational Purposes
'

#include "mos.bi"
#include "x86.bi"
#include "mos/drivercom.bi"

Extern _MOS_bootinfo Alias "_MOS_bootinfo" As Integer

Declare sub dumphex(ByVal i as unsigned integer)
Declare sub showstring(ByRef s as String)

Sub modmain CDecl Alias "main"

    drv_setname(DRIVER_MGR, 3)

    Dim curport as Integer
    Dim addresses() As Integer
    Dim senders As Integer
    senders = 1
    Redim addresses(senders)
    curport = &HCFF01000
    Yield
    Yield
    portalloc(&HE9, &HE9)

    Dim cmdlines(0 to 15) As String
    Dim cmdlinehead As Integer
    Dim cmdlinetail As Integer

    While 1 = 1

        Dim rs As String
        Dim rv As Integer
        Dim sender As Integer, target As Unsigned Integer

        While drv_peekmessage() = 0
            Dim tmp As Integer, pipe As Integer
            tmp = _MOS_bootinfo
            For pipe = &HCFF01000 to curport - &H1000 step &H1000

                _MOS_bootinfo = pipe
                rv = drv_peekmessageany(target)
                'If (rv > 0) and (pipe = &HCFF03000) Then
                '    outportb(&HE9, asc("S"))
                '    dumphex(target)
                '    outportb(&HE9, asc("-"))
                'End if
                If (rv > 0) and ((target and &HFFFF0000) > 0) Then

                    rs = space$(rv)
                    sender = drv_readmessageany(*CPtr(Byte Ptr Ptr, @rs))

                    addresses((pipe and &HFF000) SHR 12) = sender

                    'if pipe = &HCFF03000 Then
                    '    dumphex(sender)
                    '    outportb(&HE9, asc("-"))
                    '    dumphex(rv)
                    '    outportb(&HE9, asc("-"))
                    '    dumphex (*Cptr(integer ptr, &HCFF03000) - *Cptr(integer ptr, &HCFF03004))
                    '    outportb(&HE9, 10)
                    '    outportb(&HE9, 13)
                    'End If

                    'showstring "msg in: " + str$(rv) + " bytes from 0x" + hex$(pipe) + " to: 0x" + hex$(target) + " data:" + rs + chr$(13) + chr$(10)

                    _MOS_bootinfo = tmp
                    drv_sendmessageany(target, pipe, rv, *CPtr(Byte Ptr Ptr, @rs))

                    pipe = pipe - &H1000 ' check for more messages

                End If
            Next pipe
            _MOS_bootinfo = tmp

            target = 0
            rv = 0
            rv = drv_peekmessageany(target)
            'if (rv > 0) And (target = &HCFF03000) then
            '
            '    outportb(&HE9, asc("D"))
            '    dumphex(target)
            '    outportb(&HE9, asc("-"))
            '    dumphex(drv_peeksender())
            '    outportb(&HE9, asc("-"))
            '    dumphex(rv)
            '    outportb(&HE9, asc("-"))
            '    dumphex (*Cptr(integer ptr, &HCFF03000) - *Cptr(integer ptr, &HCFF03004))
            '    outportb(&HE9, 10)
            '    outportb(&HE9, 13)
            'end if
            While (rv > 0) and ((target and &HCFF00000) = &HCFF00000)

                rs = space$(rv)

                sender = drv_readmessageany(*CPtr(Byte Ptr Ptr, @rs))
                _MOS_bootinfo = target and &HCFFFF000
                target = addresses((target and &HFF000) SHR 12)

                'showstring "msg out: " + str$(rv) + " bytes from 0x" + hex$(sender) + " to: 0x" + hex$(target) + chr$(13) + chr$(10)

                drv_sendmessageany(target, sender, rv, *CPtr(Byte Ptr Ptr, @rs))

                target = 0
                rv = 0

                _MOS_bootinfo = tmp
                rv = drv_peekmessageany(target)
            Wend

            If rv > 0 Then
                'showstring "pending: " + str$(rv) + " bytes from 0x" + hex$(drv_peeksender()) + " to: 0x" + hex$(target) + ", " + str$(*cptr(integer ptr, tmp) - *cptr(integer ptr, tmp+4)) + "b space used" + chr$(13) + chr$(10)
            End If

            Yield
        Wend

        rv = drv_peekmessage()
        rs = space$(rv)
        sender = drv_readmessage(*CPtr(Byte Ptr Ptr, @rs))

        If Sender = DRIVER_MGR * &H10000 + 2 Then

            '*CPtr(Byte ptr, &HBADBABE5) = 0

            Dim vals as Integer Ptr
            vals = *CPtr(Integer Ptr Ptr, @rs)

            BlockAlloc 1, CPtr(Byte Ptr, curport)
            Dim lp As Integer Ptr
            lp = CPtr(Integer Ptr, curport)
            lp[0] = &HC0001000 + &H800
            lp[1] = &HC0001000 + &H800
            lp[2] = &HD0000000
            lp[3] = &HC0001000
            lp[4] = &HC0001000 + 10 * 4 ' command line ptr here

            Dim filler as long
            For filler = 5 to 1023
                lp[filler] = 0
            Next filler

            ' Copy command line
            ' Fixme: possible buffer overflow

            Dim cmdptr As Byte Ptr
            Dim cmdoffset As Integer
            Dim thiscmd As String
            cmdptr = cptr(Byte Ptr, curport)
            thiscmd = cmdlines(cmdlinetail)
            cmdlinetail = (cmdlinetail + 1) Mod 16
            cmdoffset = &H3FF - len(thiscmd) ' reserve null terminator
            Dim cmdp As Integer
            Dim iscmd As Integer
            dim cmdn As Integer
            cmdn = 10
            lp[cmdn] = 0
            
            'dumphex cmdptr
            'outportb(&HE9, asc(":"))
            'dumphex cmdoffset
            'outportb(&HE9, asc(":"))
            'dumphex len(thiscmd)
            'outportb(&HE9, 32)

            For cmdp = 0 to len(thiscmd) - 1
                Dim ch As Byte
                ch = asc(mid$(thiscmd, cmdp, 1))
                If ch = 0 or ch = 32 Then
                    cmdptr[cmdp+cmdoffset] = 0
                    If iscmd = 1 Then
                        iscmd = 0
                    End If
                Else
                    cmdptr[cmdp+cmdoffset] = ch
                    if iscmd = 0 then
                        lp[cmdn] = &HC0001000 + cmdoffset + cmdp
                        cmdn = cmdn + 1
                        lp[cmdn] = 0
                        iscmd = 1
                    end if
                End If
            Next cmdp
            cmdptr[cmdp+cmdoffset] = 0


            TransferPage(CPtr(Byte Ptr, curport), CPtr(Byte Ptr, &HC0001000), vals[1])

            CreateThreadRemote(vals[0], CPtr(Byte Ptr, &HC0001008), CPtr(Byte Ptr, &HFFFFFFFF&), CPtr(Byte Ptr, &HC0000000), vals[1])

            curport = curport + &H1000
            senders = senders + 1
            redim preserve addresses(senders)

            '*CPtr(Byte Ptr, &HE0A02) = 1

        Else
            Select case Asc(mid$(rs,1,1))

                Case 1      ' start program
                    ' forward app name to ELF loader

                    Dim appname As String
                    Dim cmdname As String
                    Dim sp As Integer
                    sp = Instr(4, rs, " ")              ' skip over message ID
                    If sp > 0 Then
                        appname = left$(rs, sp)
                        cmdname = mid$(rs, 4)
                    Else
                        appname = rs
                        cmdname = mid$(rs, 4)
                    End if

                    While len(appname) < 12
                        appname = appname + " "
                    Wend

                    cmdlines(cmdlinehead) = cmdname
                    cmdlinehead = (cmdlinehead + 1) Mod 16

                    drv_sendmessage(DRIVER_MGR * &H10000 + 2, 12, *CPtr(Byte Ptr Ptr, @appname))
                    '*CPtr(Byte ptr, &HBADBABE5) = 0

                    '*CPtr(Byte Ptr, &HE0A01) = 1

                Case Else
                    '*CPtr(Byte Ptr, &HE0AEE) = 1
            End Select
        End If
    Wend

End Sub

sub dumphex(ByVal i as unsigned integer)
    dim n as integer
    for n = 28 to 0 step -4
        outportb(&He9, asc(mid$("0123456789abcdef",((i SHR n) and &HF) + 1, 1)))
    next n
end sub

Sub showstring(ByRef s as String)
    Dim lp As Integer
    For lp = 0 to Len(s)
        outportb(&He9, asc(mid$(s, lp, 1)))
    Next lp
End Sub
