' Summary: queryutil.bi
' Implements an utility to expose queryinterface handles
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "mos/driver.bi"
#include "mos/driverutil.bi"
#include "mos/drivercom.bi"
#include "mos/devmgr.bi"

Constructor MCQueryUtility
    Base()
    mHandles = CPtr(Integer Ptr, 0)
    mHandleCount = 0
End Constructor

Destructor MCQueryUtility
    If (mHandles <> CPtr(Integer Ptr, 0)) Then Deallocate mHandles
End Destructor

Sub MCQueryUtility.AddInterface(ByVal interface As Integer)
    Dim n As Integer
    For n = 0 to mHandleCount - 1
        ' duplicate prevention
        if mHandles[n] = interface Then Exit Sub
    Next n
    Dim newhandles as Integer Ptr
    newhandles = Allocate((mHandleCount + 1) * Len(Integer))
    For n = 0 to mHandleCount - 1
       newhandles[n] = mHandles[n]
    Next n
    newhandles[mHandleCount] = interface
    if mHandles <> CPtr(Byte Ptr, 0) Then Deallocate mHandles
    mHandles = newhandles
    mHandleCount = mHandlecount + 1
End Sub

Sub MCQueryUtility.AnnounceDriver(ByVal deviceid As Integer)
    Dim msg() As integer
    Redim msg(2)
    msg(0) = DEVMGRCOMMANDS_SETADDR
    msg(1) = deviceid
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )
End Sub

Sub MCQueryUtility.queryinterfaces(ByVal channel As Byte Ptr)
    Dim msg() As Integer, lp As Integer
    ReDim msg(mHandleCount + 1)
   
    Asm
        mov eax, [channel]
        xchg bx, bx
    End Asm

    msg(0) = SYSCOMMAND_QUERYINTERFACES
    For lp = 0 to mHandleCount - 1
        msg(lp+1) = mHandles[lp]
    Next lp

    drv_sendmessage(CInt(channel), 4 + 4 * mHandleCount, CPtr(Byte Ptr, @(msg(0))))
End Sub
