' Summary: pci_mgr.bas
' PCI Configuration Space Manager
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

'$include once: 'mos.bi'
'$include once: 'x86.bi'
'$include once: 'mos/pci.bi'

Declare Sub ModMain CDecl Alias "main" ()
Declare Sub pcimgr_handler (ByVal f As Long, ByVal device As Long, ByVal param3 As Long, ByVal param4 As Long)
Declare Sub pcimgr_handlerstub()

' Function: ModMain
' Initialises the interface
Public Sub ModMain CDecl Alias "main" ()

    PortAlloc &HCF8, 8

    Dim stub As Sub()
    Dim index As Long

    ' create interface
    stub = @pcimgr_handlerstub
    gate = gatealloc(stub)
    index = 0

    result = 1
    while result <> 0
        result = routealloc(gate, PORTNAME("PCI" + Str(index)))
        index = index + 1
    Wend

End Sub

' Function: pcimgr_handler
' handles the incoming calls
'
' in:
'     f      - first (mangled) parameter
'     device - second parameter
'     param3 - third parameter
'     param4 - fourth parameter
'
' out:
'     f      - first return paramter (success value)
'     device - second return parameter
'     param3 - third return parameter
'     param4 - fourth return parameter
'
Sub pcimgr_handler (ByVal f As Long, ByVal device As Long, ByVal param3 As Long, ByVal param4 As Long)
    Static lockbit as long = 0

    While TaS(lockbit) = 1

    Wend

    Select case (f \ 65536)

        Case PCICALLS.PCI_GETDEVICE
            outportd(&HCF8, (device * 256) Or &H80000000)
            device = inportd(&HCFC)
            f = 0

        Case PCICALLS.PCI_READDWORD
            outportd(&HCF8, device Or &H80000000)
            device = inportd(&HCFC)
            f = 0

        Case PCICALLS.PCI_READBYTE
            outportd(&HCF8, device Or &H80000000)
            device = inportb(&HCFC)
            f = 0

        Case PCICALLS.PCI_WRITEDWORD
            outportd(&HCF8, device Or &H80000000)
            outportd(&HCFC, param3)
            f = 0

        Case PCICALLS.PCI_WRITEBYTE
            outportd(&HCF8, device Or &H80000000)
            outportb(&HCFC, param3 And &HFF)
            f = 0

        Case PCICALLS.PCI_GETBARTYPE
            if param3 >= 0 and param3 <= 5 then
                Dim temp as long
                outportd(&HCF8, (device * 256) Or &H80000000 Or (param3 * 4 + &H10))
                temp = inportd(&HCFC)
                outportd(&HCFC, &HFFFFFFFF)
                device = inportd(&HCFC)
                outportd(&HCFC, temp)
                f = 0
            else
                f = -1
            end if

        Case PCICALLS.PCI_GETBARBASE
            if param3 >= 0 and param3 <= 5 then
                outportd(&HCF8, (device * 256) Or &H80000000 Or (param3 * 4 + &H10))
                device = inportd(&HCFC)
                f = 0
            else
                f = -1
            end if

        Case PCICALLS.PCI_ENUMERATEDEV
            Dim maxdev As Long
            Dim found as Long
            Dim cachedevtype As Long
            Dim retval As Long
            found = 0
            maxdev = (device and &HFF00) + &H1FF
            outportd(&HCF8, (device * 256) Or &H80000000)
            cachedevtype = inportd(&HCFC)
            If device = -1 Then
                device = 0
                cachedevtype = 0
            ElseIf cachedevtype = 0 or cachedevtype = -1 then
                device = (device and &HFFF8) + 8
            Else
                device = device + 1
            End If

            While found = 0 And device <= maxdev
                outportd(&HCF8, (device * 256) Or &H80000000)
                retval = inportd(&HCFC)
                If retval = 0 Or retval = -1 Then
                    device = (device And &HFFF8) + 8
                Else
                    If retval = cachedevtype Then
                        device = (device And &HFFF8) + 8
                    Else
                        found = 1
                        param3 = retval
                    End If
                End If
            Wend
            If found = 0 Then
                device = -1
                param3 = -1
                f = -1
            Else
                f = param3
            End If

        Case PCICALLS.PCI_SETBARBASE
            if param3 >= 0 and param3 <= 5 then
                outportd(&HCF8, (device * 256) Or &H80000000 Or (param3 * 4 + &H10))
                outportd(&HCFC, param4)
                f = 0
            else
                f = -1
            end if

        Case Else
            f = -1
    End Select

    lockbit = 0
End Sub

' Function: pcimgr_handlerstub
' converts the register calling convention into a FB-compatible convention
Sub pcimgr_handlerstub()
    ipccdeclconv(@pcimgr_handler)
End Sub