;
; Summary: elf-runtime.asm
; *The C Runtime module for MOS programs*
;

SECTION .text

extern main
global _start

;
; Function: _start
; Default program entry point
;
; Prepares and calls the main function
;
; in:
;     (none)
;
; out:
;     (none)
;
; destroyed:
;     all non-stack registers
;

%include "inc_syscall.asm"
extern _PDCLIB_heaptop
global _MOS_bootinfo
global _MOS_cmdline
;extern _PDCLIB_actualtop

extern __ctors_start
extern __ctors_end
;extern __dtors_start
;extern __dtors_end


_start:		        MOV EDI, [ESP]
                    MOV EDX, [ESP+4]
                    MOV EAX, [ESP+8]
                    MOV [_MOS_cmdline], EAX
                    MOV ESP, lstacktop

                    MOV [_PDCLIB_heaptop], EDI
                    MOV [_MOS_bootinfo], EDX

                    STC
                    SBB ESI, ESI
                    kernel AllocatePageTable

                    ; initialize stack
                    mov EBX, 1
                    mov EDI, [_PDCLIB_heaptop]
                    kernel BlockAlloc
                    MOV EDI, [_PDCLIB_heaptop]
                    LEA ESP, [EDI+0x1000]
                    MOV [_PDCLIB_heaptop], ESP

                    ; initialize FPU
                    FNINIT

                    ; initialize C runtime
                    XOR EAX, EAX
                    MOV ECX, [_MOS_cmdline]
                    OR ECX, ECX
                    JZ .noargs
.moreargs:          MOV EDX, [ECX]
                    OR EDX, EDX
                    JZ .nomoreargs
                    INC EAX
                    ADD ECX, 4
                    JMP .moreargs
.nomoreargs:        MOV EDX, [_MOS_cmdline]

.callctors:         PUSH EAX
                    PUSH EDX

                    MOV EBX, __ctors_start
.ctorsloop:         CMP EBX, __ctors_end
                    JE .ctorsdone
                    CALL [EBX]
                    ADD EBX, 4
                    JMP .ctorsloop
.ctorsdone:
                    POP EDX
                    POP EAX

.callmain:          PUSH EDX                    ; argv
                    PUSH EAX                    ; argc
                    CALL main                   ; continue with application
                    ADD ESP, 8

.deathloop:         kernel Yield
                    JMP .deathloop              ; right now, loop forever

.noargs:            MOV EAX, 1
                    MOV EDX, _MOS_backupcmd
                    MOV [_MOS_cmdline], EDX
                    JMP .callctors


SECTION .data
    lstack: TIMES 1024 DD 0
    lstacktop:

    _MOS_bootinfo: DD 0
    _MOS_cmdline: DD 0
    _MOS_backupcmd: DD _MOS_nullname, 0
    _MOS_nullname: DB "(null)", 0