' Summary: atadef.bi
' Definitions for ATA controllers
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#ifndef __ATA_BI__
#define __ATA_BI__

' Constant: ATA_ISABASE_1
' The base register offset for the primary IDE bus on legacy systems
Const ATA_ISABASE_1 As Integer = &H1F0
' Constant: ATA_ISABASE_2
' The base register offset for the secondary IDE bus on legacy systems
Const ATA_ISABASE_2 As Integer = &H170
' Constant: ATA_ALTERNATESTATUS_BASE
' The offset of the alternate status register relative to the IO Base on legacy systems
' For instance <ATA_ISABASE_1> + ATA_ALTERNATESTATUS_BASE = &H3F6
Const ATA_ALTERNATESTATUS_BASE = &H206


' Enumeration: ATAREGS
' Lists the registers available in the first IO range
Enum ATAREGS
    ' Constant: ATA_RW_DATA
    ' The offset to the data port
    ' Data is sent to/from the drive through this port when in PIO mode,
    ' and DRQ is set in <ATA_R_STATUS>
    ' The port is 16 bits wide and should normally be accessed with REP INSW/OUTS
    '
    ' Size:
    '     16 bits
    ATA_RW_DATA = 0

    ' Constant: ATA_RW_DEVSEL
    ' Contains drive selection as well as some operation features
    ' 
    ' Size:
    '     8 bits
    ATA_RW_DEVSEL = 6

    ' Constant: ATA_W_COMMAND
    ' The offset to the command port.
    ' When a device has DRDY set in <ATA_R_STATUS>, a command can be sent by writing
    ' this port
    '
    ' Size:
    '     8 bits
    ATA_W_COMMAND = 7

    ' Constant: ATA_R_STATUS
    ' Contains the status of the drive currently selected in <ATA_RW_DEVSEL>
    ' it holds a bitfield of status flags from <ATASTATUS>
    '
    ' Size:
    '     8 bits
    ATA_R_STATUS = 7
End ENUM

' Enumeration: ATASTATUS
' Holds the bitfields present in the <ATA_R_STATUS> register
Enum ATASTATUS
    ' Constant: ATA_STATUS_ERR
    ' The device has aborted the previous command
    ATA_STATUS_ERR  = &H01

    ATA_STATUS_IDX  = &H02

    ATA_STATUS_CORR = &H04

    ' Constant: ATA_STATUS_DRQ
    ' The device is waiting for the host to perform data transfer
    ATA_STATUS_DRQ  = &H08

    ATA_STATUS_DSC  = &H10

    ' Constant: ATA_STATUS_DF
    ' The device does not operate as expected.
    ATA_STATUS_DF   = &H20
    ' Constant: ATA_STATUS_DRDY
    ' The device is ready to accept commands
    ATA_STATUS_DRDY = &H40
    ' Constant: ATA_STATUS_BUSY
    ' The device is busy executing a command.
    ATA_STATUS_BUSY = &H80
End Enum


' Enumeration: ATACOMMANDS
' Lists the possible commands a drive can understand
Enum ATACOMMANDS
    ATACOMMAND_READ_PIO          = &H20
    ATACOMMAND_READ_PIO_EXT      = &H24
    ATACOMMAND_READ_DMA          = &HC8
    ATACOMMAND_READ_DMA_EXT      = &H25
    ATACOMMAND_WRITE_PIO         = &H30
    ATACOMMAND_WRITE_PIO_EXT     = &H34
    ATACOMMAND_WRITE_DMA         = &HCA
    ATACOMMAND_WRITE_DMA_EXT     = &H35
    ATACOMMAND_CACHE_FLUSH       = &HE7
    ATACOMMAND_CACHE_FLUSH_EXT   = &HEA
    ATACOMMAND_PACKET            = &HA0
    ATACOMMAND_IDENTIFY_PACKET   = &HA1
    ATACOMMAND_IDENTIFY          = &HEC
End Enum


' Structure: ATAIDENTIFY
' The structure of the data as returned by an IDENTIFY command
Type ATAIDENTIFY Field = 1 ' as per ATA-5
    ' 0
    genconf As Short
    cylinders As Short
    configuration As Short
    heads As Short
    retired_1 As Integer
    sectorspertrack As Short ' "logical" sectors per track? Seems to be a duplicate of logical_sectorspertrack
    reserved_1 As Short
    reserved_2 As Short
    retired_2 As Short
    ' 10
    Serial(0 to 19) As Byte
    ' 20
    retired_3 As Short
    retired_4 As Short
    obsolete_1 As Short
    Firmware(0 to 7) As Byte
    Model(0 to 39) As Byte
    max_transfer As Short
    reserved_3 As Short
    capabilities_1 As Short
    ' 50
    capabilities_2 As Short
    obsolete_2 As Short
    obsolete_3 As Short
    validflags As Short
    logical_cylinders As Short
    logical_heads As Short
    logical_sectorspertrack as Short
    capacity_lo As Short
    capacity_hi As Short
    multiple_sectors_conf As Short
    ' 60
    maxlba_lo As Short
    maxlba_hi As Short
    obsolete_4 As Short
    mdma_conf As Short
    pio_conf As Short
    dma_cycle_min As Short
    dma_cycle_recommended As Short
    pio_cycle_min As Short
    pio_cycle_flowcontrol_min As Short
    reserved_4 As Short
    ' 70
    reserved_5 As Short
    reserved_6 As Short
    reserved_7 As Short
    reserved_8 As Short
    reserved_9 As Short
    queuedepth_max As Short
    reserved_10 As Short
    reserved_11 As Short
    reserved_12 As Short
    reserved_13 As Short
    ' 80
    versionsupport As Short
    versionminor As Short
    commandsupport_1 As Short
    commandsupport_2 As Short
    commandsupport_3 As Short
    commandenabled_1 As Short
    commandenabled_2 As Short
    commanddefault As Short
    udma_conf As Short
    security_erase_time As Short
    ' 90
    security_erase_enhanced_time As Short
    power_conf As Short
    password_revision As Short
    reset_result As Short
    reserved_14(0 to 11) As Byte
    ' 100
    reserved_15(0 to 19) As Byte
    ' 110
    reserved_16(0 to 19) As Byte
    ' 120
    reserved_17(0 to 13) As Byte
    removable_status_notify_support As Short
    security_status As Short
    vendor_data(0 to 61) As Byte
    ' 160
    CFA_power_mode As Short
    reserved_18(0 to 17) As Byte
    ' 170
    reserved_19(0 to 19) As Byte
    ' 180
    reserved_20(0 to 19) As Byte
    ' 190
    reserved_21(0 to 19) As Byte
    ' 200
    reserved_22(0 to 19) As Byte
    ' 210
    reserved_23(0 to 19) As Byte
    ' 220
    reserved_24(0 to 19) As Byte
    ' 230
    reserved_25(0 to 19) As Byte
    ' 240
    reserved_26(0 to 19) As Byte
    ' 250
    reserved_27(0 to 9) As Byte
    checksum As Short
End Type



#endif
