' Summary: atadisk.bas
' The driver for a generic non-packet ATA disk drive.
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

#include "mos/drivercom.bi"
#include "mos/driver.bi"
#include "mos/atabus.bi"
#include "mos/block.bi"

#include "mos.bi"
#include "x86.bi"
#include "atadef.bi"
#include "scheduler.bi"
#include "diskmm.bi"

Dim shared vram As Byte Ptr

Sub showbyte(ByVal b As Integer)
    outportb(&HE9, b)

    'vram[0] = b And &HFF&
    'vram[1] = &H1F
    'vram[2] = 0
    'vram[3] = &H7F
    'vram = @(vram[2])
End Sub

Sub showstring(ByRef s As String)
    Dim lp As Integer
    For lp = 0 to Len(s)
        showbyte(asc(mid$(s, lp, 1)))
    Next lp
End Sub

Sub modmain CDecl Alias "main" (ByVal argc As Integer, ByVal argv As Byte Ptr Ptr)

    Dim devid As Integer, parentid As Integer, parentaddr As Integer
    devid = DriverInit
    drv_setname(0,1)

    Dim msgsize As Integer
    Dim msg() As integer
    Redim msg(2)

    vram = CPtr(Byte Ptr, &HB8000)
    'blockallocphys(8, vram, vram)
    'allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))

    ' find parent driver (the one in charge of the ATA controller)
    msg(0) = 1
    msg(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )
    While drv_peekmessage() = 0
        Yield
    Wend
    Redim msg((drv_peekmessage() + 3) \ 4)
    drv_readmessage(CPtr(Byte Ptr, @(msg(0)) ) )
    If msg(0) <= 0 Then
        ' no connectivity?!
        msg(0) = 0
        msg(0) = 1 \ msg(0)
    End If
    parentid = msg(1)

    allocateiobitmap(0, &HE000, CPtr(Byte Ptr, &HFFFFFFFF))
    portalloc(&HE9, 1)
    showbyte(asc("-"))
    showbyte(asc(">"))
    showbyte(asc("A") + msg(1))
    showbyte(13)
    showbyte(10)

    ' find out how to contact the parent driver
    parentaddr = 0
    While parentaddr = 0
        msg(0) = 8
        msg(1) = parentid
        drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )
        While drv_peekmessage() = 0
            Yield
        Wend
        drv_readmessage( CPtr(Byte Ptr, @(msg(0))))
        If msg(0) <> 0 Then
            parentaddr = msg(0)
        End If
    Wend
    showbyte(asc("-"))
    showbyte(asc(">"))
    showbyte(asc("A") + msg(0))
    showbyte(asc("|"))

    redim msg(4)
    msg(0) = ATABUSCOMMAND_CMD
    msg(1) = devid
    msg(2) = &H00800100 ' data out, only CMD register
    msg(3) = &HEC ' identify
    drv_sendmessage(parentaddr, 13, CPtr(Byte Ptr, @(msg(0))) )
    
    Dim Heads As Integer, Cylinders As Integer, Tracks As Integer, LBABlocks As Integer
    While Cylinders = 0
        While drv_peekmessage() = 0
            Yield
        Wend
        showbyte(asc("|"))
        Redim msg((drv_peekmessage() + 3) \ 4)
        drv_readmessage( CPtr(Byte Ptr, @(msg(0))))

        If msg(0) = ATABUSCOMMAND_DATA Then
            Dim id as ATAIDENTIFY Ptr
            Dim debug As String
            id = CPtr(ATAIDENTIFY Ptr, @(msg(1)))
            debug = "Cyl: " & id->cylinders & ", Hds: " & id->heads & ", Sec:" & id->sectorspertrack & ", LBA: 0x" & hex$(id->maxlba_hi) & ":" & hex$(id->maxlba_lo) & chr$(13) & chr$(10)
            Cylinders = id->cylinders
            Heads = id->heads
            Tracks = id->sectorspertrack
            LBABlocks = ((CLng(id->maxlba_hi) And &HFFFF ) SHL 16 ) Or (CLng(id->maxlba_lo) And &HFFFF)
            Dim lp As Integer
            For lp = 0 To Len(debug)
                showbyte(asc(mid$(debug, lp, 1)))
            Next lp
        End If
    Wend

    ' register driver in device manager
    drv_setname(0,1)
    msg(0) = 7
    msg(1) = devid
    drv_sendmessage(DRIVER_MGR * &H10000 + 0, 8, CPtr(Byte Ptr, @(msg(0))) )

    Dim sched As Scheduler
    sched = SimpleSchedulerCreate()
    Dim pending As Integer, currentrequest As Request
    pending = 0

    DiskMM_InitMapper
    Dim bytes As Long
    bytes = CLng(lbablocks) * 512
    DiskMM_CreateRoot(0, bytes)


    ' main message loop
    While 1 = 1
        msgsize = drv_PeekMessage()
        If msgsize = 0 Then
            Yield
        Else
            Dim src As Integer
            ReDim msg(msgsize \ 4 + 5)
            ' trick: ATA data comes back with only a message id up front,
            ' blockcommands have five dwords up front. reserve space so only the header needs changing
            src = drv_readmessage(CPtr(Byte Ptr, @(msg(4)) )  )

            Select Case msg(4)
                Case SYSCOMMAND_QUERYINTERFACES
                    Redim msg(3)
                    msg(0) = SYSCOMMAND_QUERYINTERFACES
                    msg(1) = INTERFACE_BLOCK
                    msg(2) = INTERFACE_ATABUS
                    drv_sendmessage(src, 12, CPtr(Byte Ptr, @(msg(0))))
                    showstring "query" + chr$(13) + chr$(10)

                Case BLOCKDRIVERCOMMAND_GEOM
                    Redim msg(2)
                    msg(0) = BLOCKDRIVERCOMMAND_GEOM
                    msg(1) = 512
                    msg(2) = LBABlocks
                    drv_sendmessage(src, 12, CPtr(Byte Ptr, @(msg(0))))
                    showstring "geom" + chr$(13) + chr$(10)

                Case BLOCKDRIVERCOMMAND_READ
                    if msgsize <> 16 Then *CPtr(Byte Ptr, &H61800000 + msgsize ) = 0
                    Dim req As Request, ext As DISKMM_Extent, trans As DISKMM_TRANSLATION Ptr, temptrans As DISKMM_TRANSLATION Ptr
                    ext.StartLocation = CLng(msg(2 + 4)) * 512
                    ext.EndLocation = CLng(msg(3 + 4)) * clng(512) - clng(1) + ext.StartLocation
                    showstring "read [1]: " + str$(ext.Startlocation) + "-" + str$(ext.Endlocation) + " from map: " + str$(msg(1+4)) + chr$(13) + chr$(10)

                    trans = DiskMM_Translate(msg(1+4), src, ext)
                    while trans <> Cptr(DISKMM_TRANSLATION Ptr, 0)
                        showstring "read [2]: " + str$(trans->extent.Startlocation) + "-" + str$(trans->extent.Endlocation) + chr$(13) + chr$(10)
                        req.block = trans->extent.StartLocation \ 512
                        req.numblocks = (trans->extent.EndLocation + 1) \ 512 - req.block
                        req.direction = 1
                        req.priority = 1
                        req.requester = src
                        req.sourceblock = ext.StartLocation \ 512
                        ext.StartLocation = ext.StartLocation + req.numblocks * 512
                        req.sourcemap = msg(1+4)
                        req.custom = CPtr(Byte Ptr, 0)
                        showstring "read [3]: " + str$(req.numblocks) + "@" + str$(req.block) + chr$(13) + chr$(10)
                        sched.AddRequest(@sched.privatedata, req)

                        temptrans = trans
                        trans = CPtr(DISKMM_TRANSLATION Ptr, trans->NextBlock)
                        Deallocate temptrans

                    Wend

                Case ATABUSCOMMAND_DATA
                    If src = parentaddr Then
                        msg(1) = BLOCKCLIENTCOMMAND_DATA
                        msg(2) = CInt(currentrequest.sourcemap)
                        msg(3) = currentrequest.sourceblock
                        msg(4) = 512
                        drv_sendmessage(currentrequest.requester, msgsize + 12, CPtr(Byte Ptr, @(msg(1))))
                        pending = 0
                    End If
                    showstring "data" + chr$(13) + chr$(10)

                Case BLOCKDRIVERCOMMAND_ADDMAP
                    If msgsize <> 16 Then *CPtr(Byte Ptr, &H61900000 + msgsize ) = 0
                    msg(2) = DiskMM_NewMapping()
                    DiskMM_SetMapProperties(msg(2), src, *CPtr(Long Ptr, @(msg(6))))
                    msg(0) = BLOCKDRIVERCOMMAND_NEWMAP
                    msg(3) = msg(4)
                    msg(4) = msg(5)
                    drv_sendmessage(src, 20, CPtr(Byte Ptr, @(msg(0))))
                    Dim debug As String, lp as integer
                    debug = "createmap: " + str$(msg(2)) + ", " + str$(msg(4)) + " bytes " + chr$(13) + chr$(10)
                    showstring debug

                    'For lp = 0 To Len(debug)
                    '    showbyte(asc(mid$(debug, lp, 1)))
                    'Next lp

                Case BLOCKDRIVERCOMMAND_SETEXTENT
                    If msgsize <> 40 Then *CPtr(Byte Ptr, &H61900000 + msgsize ) = 0
                    Dim extent As DISKMM_EXTENT
                    '      4              5               6                 7-8                9            10-11     12-13
                    '36: <command> <request no> <(4) source map> <(8) source start> <(4) dest map> <(8) dest start> <(8) size>
                    extent.StartLocation = msg(7)
                    extent.EndLocation = msg(12) - extent.StartLocation - 1
                    extent.ParentLevel = msg(9)
                    extent.ParentStart = msg(10)
                    extent.Privileges = SECTORSTATUS_RW                    
                    Dim debug As String, lp as integer
                    'debug = "mapping insert: " + str$(msg(6)) + ":0x" + hex$(extent.startlocation) + "-0x" + hex$(extent.EndLocation) + " to " + str$(extent.parentlevel) + ":0x" + hex$(extent.ParentStart) + chr$(13) + chr$(10)
                    'showstring debug
                    If DiskMM_Insert(msg(6), extent) <> 0 Then *CPtr(Byte Ptr, &H61A00000 + msg(6) ) = 0
                    
                    'debug = "mapping: " + str$(msg(6))+ ":" + str$(msg(7)) + " to " + str$(msg(9)) + ":" + str$(msg(8)) + ", " + str$(msg(11)) + " bytes " + chr$(13) + chr$(10)
                    'showstring debug

                Case Else
                    *CPtr(Byte Ptr, &H61700000 + msg(4) ) = 0
            End Select

            ' send commands to the ATA controller, if needed
            If pending = 0 Then
                If Sched.IsEmpty(@sched.privatedata) = 0 Then
                    currentrequest = Sched.PopRequestSingle(@Sched.privatedata)
                    If currentrequest.direction = 1 Then

                        ' packet form:
                        ' 0        1        2          3          4
                        ' idididid idididid nn dd rrrr hd rrrr nb l0 l1 l2 op

                        redim msg(5)
                        msg(0) = ATABUSCOMMAND_CMD
                        msg(1) = devid
                        '          rrrrddnn
                        msg(2) = &H00400100 ' id = 0, data out, only devsel register (0040)
                        '          nbrrrrhd
                        msg(3) = &H0100BCE0 ' devsel = LBA bit + reserved (E0), next registers: seccount+lba012+command, seccount = 1
                        msg(4) = (currentrequest.block And &H00FFFFFF) Or (ATACOMMAND_READ_PIO SHL 24) 'LBA0..2 = block, send command
                        drv_sendmessage(parentaddr, 20, CPtr(Byte Ptr, @(msg(0))) )
                        pending = 1
                    End If
                    showstring "request" + chr$(13) + chr$(10)
                End If
            End If
        End If
    Wend

    sched.Release(sched.PrivateData)

End Sub
