' Summary: blocktool.bas
' Contains some utility functions for reading sectors
'
' Author:
'     Marcel Sondaar
'
' License:
'     Public Domain
'

#include "mos/block.bi"
#include "mos/drivercom.bi"
#include "mos.bi"

Function ReadDevblock(ByVal DevAddr as Integer, ByVal Mapping as Integer, ByVal dataout as Unsigned Byte Ptr, ByVal block as Long) As Integer
    Dim msgdata(0 to 4) As Integer

    msgdata(0) = BLOCKDRIVERCOMMAND_READ  ' read
    msgdata(1) = Mapping            ' map 0 (untranslated)
    msgdata(2) = block              ' starting block
    msgdata(3) = 1                  ' block count
    drv_sendmessage(DevAddr, 16, CPtr(Byte Ptr, @(msgdata(0))) )

    Dim rv As Integer
    rv = drv_peekmessage()

    While rv = 0
        Yield
        rv = drv_peekmessage()
    Wend    

    Dim getbytes() As Byte
    redim getbytes(rv)
    drv_readmessage(@getbytes(0))    

    Dim lp as Integer
    For lp = 0 to rv - 16 - 1
        dataout[lp] = getbytes(lp+16)
    Next lp
    
    Function = 1
End Function
