' Summary: diskmm.bi
' Support code header for disk access management
'
' Author:
'     Marcel Sondaar
'
' License:
'     <Public Domain>
'

' Type: DISKMM_EXTENT
' Describes one extent in the disk's MM hierarchy
Type DISKMM_EXTENT
    ' Variable: StartLocation
    ' The location in the current map where this extent starts (inclusive)
    StartLocation As Long

    ' Variable: EndLocation
    ' The location in the current map where this extend ends (inclusive)
    EndLocation As Long

    ' Variable: ParentStart
    ' The location in the parent map corresponding to Startlocation
    ParentStart As Long

    ' Variable: ParentLevel
    ' The map index of the parent
    Parentlevel As Integer

    ' Variable: Privileges
    ' Bitmask containing privilege options of the extent
    Privileges As Integer
End Type

' Type: DISKMM_EXTENTTREE
' Describes a node in the binary tree of extents
Type DISKMM_EXTENTTREE
    Extent As DISKMM_EXTENT
    Left As Byte Ptr
    Right As Byte Ptr
    Weight As Integer
End Type

' Type: DISKMM_MAPPING
' Describes a virtual sector mapping
Type DISKMM_MAPPING
    Size As Long
    Root As DISKMM_EXTENTTREE Ptr
    Privileges As Integer
    Owner As Integer
End Type


' Type: DISKMM_TRANSLATION
' Structure that contains a list of extents
Type DISKMM_TRANSLATION
    OriginalStart As Long
    Extent As DISKMM_EXTENT
    NextBlock As Byte Ptr
End Type

' Enumeration: SECTORSTATUS
' A series of privilege and return value bits that describe the sector.
Enum SECTORSTATUS
    SECTORSTATUS_NOPRIV = 0
    SECTORSTATUS_R = 1
    SECTORSTATUS_W = 2
    SECTORSTATUS_RW = 3
    SECTORSTATUS_SUSPEND = 4
    SECTORSTATUS_HIDELEVEL = 8
    SECTORSTATUS_INVALID = 256
End Enum

Declare Function DiskMM_CreateMapping CDecl Alias "DiskMM_CreateMapping" () As DISKMM_MAPPING Ptr
Declare Function DiskMM_NewMapping CDecl Alias "DiskMM_NewMapping" () As Integer
Declare Sub DiskMM_InitMapper CDecl Alias "DiskMM_InitMapper" ()
Declare Sub DiskMM_SetMapProperties CDecl Alias "DiskMM_SetMapProperties" (ByVal Map as Integer, ByVal Owner as Integer, ByVal Size as Long)
Declare Function DiskMM_FillSingle CDecl Alias "DiskMM_FillSingle" (ByVal map As DISKMM_MAPPING Ptr, ByVal Owner as Integer, ByVal Size as Long) As Integer
Declare Function DiskMM_Translate CDecl Alias "DiskMM_Translate" (ByVal map As Integer, ByVal Requester as Integer, ByRef Extent As DISKMM_EXTENT) As DISKMM_TRANSLATION Ptr
Declare Function DiskMM_TranslateUnsafe CDecl Alias "DiskMM_TranslateUnsafe" (ByVal map As Integer, ByVal Requester as Integer, ByVal Extent As DISKMM_EXTENT Ptr, ByRef Validated as Integer) As DISKMM_TRANSLATION Ptr
Declare Function DiskMM_FoldTranslate CDecl Alias "DiskMM_FoldTranslate" (ByVal node As DISKMM_EXTENTTREE Ptr, ByVal Requester As Integer, ByVal Extent as DISKMM_EXTENT Ptr, ByVal Validated As Integer) As DISKMM_TRANSLATION Ptr
Declare Sub DiskMM_CreateRoot CDecl Alias "DiskMM_CreateRoot" (ByVal Owner As Integer, ByVal Size as Long)

Declare Function DiskMM_Insert CDecl Alias "DiskMM_Insert" (ByVal map As Integer, ByRef extent as DISKMM_EXTENT) As Integer
Declare Function DiskMM_InsertNodeEx CDecl Alias "DiskMM_InsertNodeEx" (ByVal root As DISKMM_MAPPING Ptr, ByVal newnode As DISKMM_EXTENTTREE Ptr) As Integer
Declare Function DiskMM_InsertNodeExPrime CDecl Alias "DiskMM_InsertNodeExPrime" (ByVal root As DISKMM_EXTENTTREE Ptr, ByVal newnode As DISKMM_EXTENTTREE Ptr) As Integer

