/** Summary: diskmm.bi
 * Support code header for disk access management
 *
 * Author:
 *     Marcel Sondaar
 *     
 * License:
 *     <Public Domain>
 */

// Type: DISKMM_EXTENT
// Describes one extent in the disk's MM hierarchy
typedef struct DISKMM_EXTENT
{
    // Variable: StartLocation
    // The location in the current map where this extent starts (inclusive)
    long StartLocation;

    // Variable: EndLocation
    // The location in the current map where this extend ends (inclusive)
    long EndLocation;

    // Variable: ParentStart
    // The location in the parent map corresponding to Startlocation
    long ParentStart;

    // Variable: ParentLevel
    // The map index of the parent
    int Parentlevel;

    // Variable: Privileges
    // Bitmask containing privilege options of the extent
    int Privileges;
} DISKMM_EXTENT;

// Type: DISKMM_EXTENTTREE
// Describes a node in the binary tree of extents
typedef struct DISKMM_EXTENTTREE
{
    DISKMM_EXTENT Extent;
    struct DISKMM_EXTENTTREE * Left;
    struct DISKMM_EXTENTTREE * Right;
    int Weight;
} DISKMM_EXTENTTREE;

// Type: DISKMM_MAPPING
// Describes a virtual sector mapping
typedef struct DISKMM_MAPPING
{
    long Size;
    DISKMM_EXTENTTREE * Root;
    int Privileges;
    int Owner;
} DISKMM_MAPPING;


// Type: DISKMM_TRANSLATION
// Structure that contains a list of extents
typedef struct DISKMM_TRANSLATION
{
    long OriginalStart;
    DISKMM_EXTENT Extent;
    struct DISKMM_TRANSLATION * NextBlock;
} DISKMM_TRANSLATION;

// Enumeration: SECTORSTATUS
// A series of privilege and return value bits that describe the sector.
enum SECTORSTATUS
{
    SECTORSTATUS_NOPRIV = 0,
    SECTORSTATUS_R = 1,
    SECTORSTATUS_W = 2,
    SECTORSTATUS_RW = 3,
    SECTORSTATUS_SUSPEND = 4,
    SECTORSTATUS_HIDELEVEL = 8,
    SECTORSTATUS_INVALID = 256
};

DISKMM_MAPPING * DiskMM_CreateMapping();
int DiskMM_NewMapping();
void DiskMM_InitMapper();
void DiskMM_SetMapProperties(int Map, int Owner, long Size);
int DiskMM_FillSingle (DISKMM_MAPPING * map, int Owner, long Size);
DISKMM_TRANSLATION * DiskMM_Translate (int Map, int Requester, DISKMM_EXTENT * Extent);
DISKMM_TRANSLATION * DiskMM_TranslateUnsafe (int map, int Requester, DISKMM_EXTENT * Extent, int Validated);
DISKMM_TRANSLATION * DiskMM_FoldTranslate (DISKMM_EXTENTTREE * node, int Requester, DISKMM_EXTENT * Extent, int Validated);
void DiskMM_CreateRoot (int Owner, long Size);

int DiskMM_Insert (int map, DISKMM_EXTENT * Extent);
int DiskMM_InsertNodeEx (DISKMM_MAPPING * Root, DISKMM_EXTENTTREE * Newnode);
int DiskMM_InsertNodeExPrime (DISKMM_EXTENTTREE * Root, DISKMM_EXTENTTREE * Newnode);

